#!/bin/bash
CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
source ${CURRENT_PATH}/common.sh
SCRIPTNAME=$(basename $0)

echo "Password:"
read -rs parameters
mode=$(echo "${parameters}" | awk '{print $4}')

config_upgrade_mark_info "upgrade"

if [ "${role}"x == "dpc_compute"x ] && [ -f ${CURRENT_PATH}/dpc.sh ] && [ "${mode}"x == "online"x ]; then
    bash ${CURRENT_PATH}/dpc.sh
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME  "[ERROR] upgrade dpc check failed!"
        exit 1
    fi
fi
log $SCRIPTNAME  "[INFO] begin to upgrade ${mode}"
nohup bash ${CURRENT_PATH}/compute_upgrade_inner.sh >/dev/null 2>&1 <<EOF &
${parameters}
EOF
ret=$?
exit ${ret}
