#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh
UPGRADE_STATUS_PATH="${BASE_PATH}/compute_upgrade.ini"

function main()
{
    #检查参数
    local params="$1"
    token=$(echo "${params}" | awk '{print $1}')
    flag=$(echo "${params}" | awk '{print $2}')
    float_ip=$(echo "${params}" | awk '{print $3}')
    mode=$(echo "${params}" | awk '{print $4}')
    rm -rf "${UPGRADE_STATUS_PATH}"
    upgrade_status "${status_initial}"
    check_param "${flag}" "${float_ip}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to check parameters!"
        upgrade_status "${status_failed}"
        return 1
    fi
    upgrade_status "${status_running}"
    download_package "${download_upgrade}" "${float_ip}" "${token}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to download the upgrade package!"
        upgrade_status "${status_failed}"
        return 1
    fi
    if [ -f "${FILE_PATH}/${package_name}/action/support_patch_download.ini" ]; then
        query_patch_package "${float_ip}" "${token}"
        ret=$?
        if [ "${ret}" -eq 2 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to query patch package!"
            upgrade_status "${status_failed}"
            return 1
        fi
        if [ "${ret}" -eq 0 ]; then
            download_patch_package "${download_patch}" "${float_ip}" "${token}"
            if [ $? -ne 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to download the upgrade patch package!"
                upgrade_status "${status_failed}"
                return 1
            fi
        fi
    fi
    if [ "${role}"x == "compute"x ]; then
        bash ${FILE_PATH}/${package_name}/action/upgrade.sh
    elif [ "${role}"x == "dpc_compute"x ]; then
        bash ${CURRENT_PATH}/dpc_unset_handle_input.sh #  把handle_input函数首行强制返回0
        bash ${FILE_PATH}/${package_name}/action/upgrade.sh "${mode}"
    else
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] not pure compute node, cannot upgrade!"
        upgrade_status "${status_failed}"
        return 1
    fi
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to perform the upgrade!"
        upgrade_status "${status_failed}"
        return 1
    fi
    upgrade_status "${status_success}"
    rm -rf "${FILE_PATH}"
	rm -f "${BAK_CLOUDA_CONFIG}"
    return 0
}

{
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
    echo "$$" > ${LOCKFILE}
    read -rs parameters
    main "${parameters}"
    ret=$?
    flock -u 3
} 3<>${LOCKFILE}
exit ${ret}