#!/bin/bash
CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh

DPC_LOG_DIR="/var/log/dpc_script"
DPC_LOG_FILE="dpc.action.log"
PKG_PATH=${FILE_PATH}/${package_name}
DPC_SCRIPT=${PKG_PATH}/action/preupgrade/check/dpc.sh
function init_log()
{
    if [ ! -d "$DPC_LOG_DIR" ]; then
        mkdir -p $DPC_LOG_DIR
    fi

    if [ ! -f "$DPC_LOG_DIR/$DPC_LOG_FILE" ]; then
        touch "$DPC_LOG_DIR/$DPC_LOG_FILE"
    fi

    return
}

function LOG()
{
    if [ ! -L "$DPC_LOG_DIR/$DPC_LOG_FILE" ]; then
        echo "[`date "+%Y-%m-%d %T"`:$$][${FUNCNAME[1]}]$*" >> "$DPC_LOG_DIR/$DPC_LOG_FILE"
    fi
}

function LOG_ERR()
{
    if [ ! -L "$DPC_LOG_DIR/$DPC_LOG_FILE" ]; then
        echo "[`date "+%Y-%m-%d %T"`:$$][${FUNCNAME[1]}][ERR]$*" >> "$DPC_LOG_DIR/$DPC_LOG_FILE"
    fi
}

function main()
{
    [ ! -d "$PKG_PATH" ] && LOG_ERR "[Line:${LINENO}][ERROR] no ${FILE_PATH}/${package_name}" && return 1
    
    [ ! -f "$DPC_SCRIPT" ] && LOG_ERR "[Line:${LINENO}][ERROR] no ${DPC_SCRIPT}" && return 1
    LINE_NUMS=($(grep -n handle_input $DPC_SCRIPT | grep -v function | awk -F ':' '{print $1}'))
    for num in ${LINE_NUMS[*]}
    do
        sed -i ''$num's/handle_input/#handle_input/' $DPC_SCRIPT
        [[ $? -ne 0 ]] && LOG_ERR "[Line:${LINENO}][ERROR] fail sed -i ''$num's/handle_input/#handle_input/' $DPC_SCRIPT" && return 1
    done
    return 0
}

main
exit $?
