#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
source ${CURRENT_PATH}/common.sh
SCRIPTNAME=$(basename $0)
UPGRADE_STATUS_PATH="${BASE_PATH}/compute_upgrade.ini"

function main() {
    local params="$1"
    float_ip=$(echo "${params}" | awk '{print $1}')
    token=$(echo "${params}" | awk '{print $2}')
    rm -rf "${UPGRADE_STATUS_PATH}"

    upgrade_status "${status_download_initial}"
    check_param "${float_ip}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to check parameters!"
        upgrade_status "${status_download_failed}"
        return 1
    fi

    upgrade_status "${status_download_running}"
    download_package "${download_upgrade}" "${float_ip}" "${token}"
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to download or uncompress the upgrade package!"
        upgrade_status "${status_download_failed}"
        return 1
    fi

    if [ -f "${FILE_PATH}/${package_name}/action/support_patch_download.ini" ]; then
        query_patch_package "${float_ip}" "${token}"
        ret=$?
        if [ "${ret}" -eq 2 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to query patch package!"
            upgrade_status "${status_download_failed}"
            return 1
        fi
        if [ "${ret}" -eq 0 ]; then
            download_patch_package "${download_patch}" "${float_ip}" "${token}"
            if [ $? -ne 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Failed to download or uncompress the upgrade patch package!"
                upgrade_status "${status_download_failed}"
                return 1
            fi
        fi
    fi

    upgrade_status "${status_download_success}"
    return 0
}



{
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
    echo "$$" > ${LOCKFILE}
    read -rs parameters
    main "${parameters}"
    ret=$?

    flock -u 3
} 3<>${LOCKFILE}
exit ${ret}
