#!/bin/bash
CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
source ${CURRENT_PATH}/common.sh
SCRIPTNAME=$(basename $0)

echo "Password:"
read -rs parameters
mode=$(echo "${parameters}" | awk '{print $4}')

# 检查是否存在其他方式升级
compute_upgrade_flag=/opt/fusionstorage/upgrade_flag
if [ -f "${compute_upgrade_flag}" ];then
    upgrade_mode=`grep -a "mode" "${compute_upgrade_flag}" | awk -F '=' '{print $2}'`
    if [ "${upgrade_mode}" != "tool" ];then
        # 计算节点正在通过ui升级中
        log $SCRIPTNAME  "[ERROR] The compute node is being upgraded, upgrade mode is ${upgrade_mode}."
        exit 1
    fi
else
    # 不存在计算节点升级标记文件
    touch "${compute_upgrade_flag}"
    echo -e "mode=tool" >> "${compute_upgrade_flag}"
    log $SCRIPTNAME  "[INFO] Using SmartKit to Upgrade Compute Nodes."
fi

config_upgrade_mark_info "upgrade"

if [ "${role}"x == "dpc_compute"x ] && [ -f ${CURRENT_PATH}/dpc.sh ] && [ "${mode}"x == "online"x ]; then
    bash ${CURRENT_PATH}/dpc.sh
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME  "[ERROR] upgrade dpc check failed!"
        exit 1
    fi
fi
log $SCRIPTNAME  "[INFO] begin to upgrade ${mode}"
nohup bash ${CURRENT_PATH}/compute_upgrade_inner.sh >/dev/null 2>&1 <<EOF &
${parameters}
EOF
ret=$?
exit ${ret}
