# -*- coding: UTF-8 -*-
import re

from cbb.frame.cli import cliUtil
from cbb.frame.base.exception import UnCheckException

RISK_VERSION = re.compile("6.0.1.*")
SAFETY_HOT_PATCH = 6

# LUN的卷ID检查,风险版本范围
RISK_NIC_BOND_MODE_MODEL = (
    "OceanStor Dorado 18800K V6",
    "OceanStor Dorado 18000 V6",
    "OceanStor Dorado 18500 V6",
    "OceanStor Dorado 18800 V6",
    "OceanStor Dorado 8000 V6",
    "OceanStor Dorado 6800 V6",
)


class CheckNicBondMode:
    """
    高端环境绑定端口检查
    """

    def __init__(self, cli, lang, env, logger):
        self.cli = cli
        self.conn_cli = ""
        self.lang = lang
        self.env = env
        self.logger = logger
        self.all_ret_list = []
        self.product_model = ""
        self.software_version = ""
        self.hot_patch_version = ""

    def execute_check(self):
        # 查询到的版本不在名单内检查项直接通过
        if not self.is_risk_version():
            return True
        flag = self.risk_judgment()
        return flag

    def risk_judgment(self):
        cmd = "show bond_port"
        flag, ret, err_msg = cliUtil.excuteCmdInCliMode(
            self.cli, cmd, True, self.lang
        )
        self.all_ret_list.append(ret)
        if flag is not True:
            raise UnCheckException(err_msg)
        member_list = cliUtil.getHorizontalCliRet(ret)
        if member_list:
            return False
        return True

    def is_risk_version(self):
        (
            flag,
            self.product_model,
            _,
            msg,
        ) = cliUtil.getProductModelAndVersion(self.cli, self.lang)
        self.all_ret_list.append(msg)
        if flag is not True:
            raise UnCheckException(msg)
        if self.product_model not in RISK_NIC_BOND_MODE_MODEL:
            return False
        (
            flag,
            self.software_version,
            self.hot_patch_version,
            ret
        ) = cliUtil.get_system_version_with_ret(self.cli, self.lang)
        self.all_ret_list.append(ret)
        if self.software_version == "6.0.1":
            pattern = re.compile(r"SPH(\d+)", flags=re.IGNORECASE)
            match_hot_path = pattern.search(self.hot_patch_version)
            if not match_hot_path:
                return True
            if int(match_hot_path.group(1)) < SAFETY_HOT_PATCH:
                return True
        return False
