# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.utils import ManualConfigItemMgr

from cbb.frame.base import baseUtil


def execute(data_dict, package_ver_dict):
    """
    检查阵列的VRC版本是否和补丁包的VRC版本配套
    :param data_dict: 上下文信息
    :param package_ver_dict: 补丁包版本信息
    :return: True：配套；False：不配套
    """
    dev = data_dict.get('dev')
    dev_ip = dev.getIp()
    logger = data_dict.get('logger')
    lang = data_dict.get("lang")

    if ManualConfigItemMgr.getInstance().expected(
            dev_ip, "skip.patch.vrc.check", "yes"):
        logger.info("skip patch vrc version check.")
        return True, ""

    sys_version_supported = package_ver_dict.get("SysVersionSupported", "")
    if sys_version_supported != "1":
        return True, ""

    dev_version = dev.getProductVersion()
    dev_vrc = baseUtil.getVRCVersion(dev_version)
    pkg_b_support_ver = package_ver_dict.get("SysVersionBSupported", "")
    pkg_b_support_vrc = baseUtil.getVRCVersion(pkg_b_support_ver)
    logger.info("dev_vrc is %s and pkg_b_support_vrc is %s" %
                (dev_vrc, pkg_b_support_vrc))
    if dev_vrc.lower() == pkg_b_support_vrc.lower():
        return True, ""

    ManualConfigItemMgr.getInstance().addItem(
        dev_ip, "skip.patch.vrc.check", "no",
        "skip vrc version check")
    err_msg = baseUtil.getPyResource(lang, "upload.vrc.version.not.match")
    return False, err_msg
