# -*- coding: UTF-8 -*-

from cbb.business.operate.expansion import common
from cbb.business.operate.expansion.enclosure.v5HighEnd import fullBayFuncUtils
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil

COLUMN_ITEM_SCRIPT = {
    "expandDiskBay": {
        "0": "expandDiskBay/selectCabinet.py",
        "1": "expandDiskBay/select2UEnclosure.py",
        "2": "expandDiskBay/select4UEnclosure.py",
        "3": "expandDiskBay/deleteCabinetData.py",
    },
    "expandDiskBayNVMe": {
        "0": "expandDiskBay/selectCabinet.py",
        "1": "expandDiskBay/select2UEnclosure.py",
        "2": "expandDiskBay/select4UEnclosure.py",
        "3": "expandDiskBay/select2UNVMeEnclosure.py",
        "4": "expandDiskBay/deleteCabinetData.py",
    },
}

COLUMN_ITEM_TYPE_MIX = {
    "0": "dropDown",
    "1": "dropDown",
    "2": "dropDown",
    "3": "dropDown",
    "4": "button",
}

COLUMN_ITEM_PARAM_MIX = {
    "0": "cabinet",
    "1": "2UEnclosure",
    "2": "4UEnclosure",
    "3": "2UNVMeEnclosure",
    "4": "delete",
}

COLUMN_ITEM_TYPE = {
    "0": "dropDown",
    "1": "dropDown",
    "2": "dropDown",
    "3": "button",
}

COLUMN_ITEM_PARAM = {
    "0": "cabinet",
    "1": "2UEnclosure",
    "2": "4UEnclosure",
    "3": "delete",
}

COLUMN_ITEM_TYPE_NO_4U = {
    "0": "dropDown",
    "1": "dropDown",
    "2": "button",
}

COLUMN_ITEM_PARAM_NO_4U = {
    "0": "cabinet",
    "1": "2UEnclosure",
    "2": "delete",
}

# 5列时每列宽度
ITEM_LENGTH_FIVE = "86"
# 4列时每列宽度
ITEM_LENGTH_FOUR = "108"
# 3列时的宽度
ITEM_LENGTH_THREE = "144"


def createTableItem(columnNum, itemId, label, columnType, scriptFile,
                    param, rule=[], **kwargs):
    """动态生成每行数据

    :param columnNum: 配置列数
    :param itemId: 控件ID
    :param label: 列标签
    :param columnType: 列类型
    :param scriptFile: 触发的脚本路径
    :param param: 参数
    :param rule: 配置规则
    :param kwargs: 可选参数
    :return:
    """
    MaxDropDownColumn = 4  # 最多下拉框列数
    columnWidth = ITEM_LENGTH_FIVE if columnNum == 5 else \
        ITEM_LENGTH_FOUR if columnNum == 4 else ITEM_LENGTH_THREE
    tableItem = {}
    if columnType == "label" or columnType == "button":
        tableItem = {
            "id": itemId,
            "type": columnType,
            "combo": "",
            "content": {
                "length": columnWidth,
                "label": label,
                "lableLayout": "center",
                "script": scriptFile,
                "param": "",
                "default": label,
                "refreshItems": ""
            }
        }
    if columnType == "dropDown":
        # 最后一个下拉框配置refreshItems为控
        curItemId = int(itemId)
        refreshItems = [str(refreshId) for refreshId in range(
            curItemId + 1, MaxDropDownColumn)]
        refreshItems = ','.join(refreshItems)

        tableItem = {
            "id": itemId,
            "type": columnType,
            "combo": "true",
            "content": {
                "length": columnWidth,
                "label": label,
                "script": scriptFile,
                "param": param,
                "rule": rule,
                "default": "",
                "refreshItems": refreshItems
            }
        }
    return tableItem


def getCabinetRule(context):
    """获取柜名的下拉框显示内容

    :param context:
    :return:
    """
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    rule = ",".join(availableCabinets)
    return rule


def getEnclosureRule(context, cabinetName, curEncHeight):
    """ 获取对应柜下硬盘框的rule（包括2U、4U硬盘框）

    :param context: 上下文
    :param cabinetName: 柜名
    :param curEncHeight: 选择的硬盘框高
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    selectedEnc2UNum, selectedEnc4UNum = \
        contextUtil.getSelectedEncNumByCabinet(context, cabinetName)
    logger.logInfo("selected enclosure 2U [%d], 4U [%d]" %
                   (selectedEnc2UNum, selectedEnc4UNum))

    availableEncNum = fullBayFuncUtils.get_available_enc_num(context,
                                                             cabinetName,
                                                             curEncHeight)

    logger.logInfo("enclosure type [%sU], number [%s]" %
                   (str(curEncHeight), str(availableEncNum)))

    if str(curEncHeight) == "4" \
            and not contextUtil.getItem(context, "support4UDiskEnclosure"):
        availableEncNum = 0
    # 加1是为了界面显示到最大数量
    availableEncs = [str(e) for e in range(availableEncNum + 1)]
    rule = ",".join(availableEncs)
    return rule


def getRules(context):
    """初始化每行中各控件的rule

    :param context:
    :return:
    """
    logger = common.getLogger(context.get("logger"), __file__)
    rules = []
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    logger.logInfo("availableCabinets:%s" % str(availableCabinets))
    support_sas_nvme_mix = contextUtil.getItem(context,
                                               "supportSASandNVMeMix", False)

    cabinetName = availableCabinets[0]  # 取第一个柜为初始化默认柜


    # 柜的rule
    cabinetRule = getCabinetRule(context)
    rules.append(cabinetRule)

    # 2U框的rule
    enc2UHeight = 2
    enc2URule = getEnclosureRule(context, cabinetName, enc2UHeight)

    rules.append(enc2URule)

    enc4UHeight = 4
    logger.logInfo("support4UDiskEnclosure:%s" % str(
        contextUtil.getItem(context, "support4UDiskEnclosure")))
    if not contextUtil.getItem(context, "support4UDiskEnclosure"):
        enc4URule = '0'
    else:
        enc4URule = getEnclosureRule(context, cabinetName, enc4UHeight)
    rules.append(enc4URule)

    if support_sas_nvme_mix:
        # 2框NVMe混插的rule
        enc2UHeight = 3
        logger.logInfo("supportSASandNVMeMix:%s" % str(
            contextUtil.getItem(context, "supportSASandNVMeMix")))
        if not contextUtil.getItem(context, "supportSASandNVMeMix"):
            enc2UNVMeRule = '0'
        else:
            enc2UNVMeRule = getEnclosureRule(context, cabinetName, enc2UHeight)
        rules.append(enc2UNVMeRule)

    rules.append("")  # 最后一项为操作按钮，无rule

    # 初始化数据
    curRowConfigInfo = {
        "cabinetName": cabinetName,
        "newEnc2UList": [],
        "newEnc4UList": [],
        "newEnc2UNVMeList": [],
    }
    # 更新扩容配置信息
    rowId = contextUtil.getItem(context, "curRow")
    selectedConfig = contextUtil.getItem(context, "selectedConfig")
    selectedConfig.setdefault(str(rowId), curRowConfigInfo)
    contextUtil.setItem(context, "selectedConfig", selectedConfig)
    logger.logInfo("update rowId:%s" % str(rowId))
    # 更新已选柜的列表
    contextUtil.updateSelectedCabinets(context)
    return rules


def getItemInfoDict(context, tableHeadFlag=False):
    """动态生成每行属性的字典，最多支持五列，多列需手动添加

    :param context: 上下文
    :param tableHeadFlag: 是否是表头信息
    :return:
    """
    lang = contextUtil.getLang(context)
    dae_enc_type = contextUtil.getItem(context, "daeEnclosureType")
    support_4U_enc = contextUtil.getItem(context,
                                         "support4UDiskEnclosure", False)
    support_sas_nvme_mix = contextUtil.getItem(context,
                                               "supportSASandNVMeMix", False)
    if tableHeadFlag:
        return get_head_item_info(lang, support_sas_nvme_mix,
                                  support_4U_enc, dae_enc_type)

    return get_body_item_info(context, lang, support_sas_nvme_mix,
                              support_4U_enc)


def get_head_item_info(lang, support_sas_nvme_mix,
                       support_4U_enc, dae_enc_type):
    """生成表头信息

    :param lang: 语言
    :param support_sas_nvme_mix: 是否支持SAS_NVME混插
    :param support_4U_enc: 是否支持4U框
    :param dae_enc_type: 后端组网类型
    :return:
    """
    if support_sas_nvme_mix:
        labels = [
            common.getRes(lang, "cabinet_name_tableTitle"),
            common.getRes(lang, "2UEnclosure_number_tableTitle"),
            common.getRes(lang, "4UEnclosure_number_tableTitle"),
            common.getRes(lang, "2UEnclosure_number_tableTitle_ip"),
            common.getRes(lang, "operate_tableTitle")
        ]
    elif support_4U_enc:
        labels = [
            common.getRes(lang, "cabinet_name_tableTitle"),
            common.getRes(lang, "2UEnclosure_number_tableTitle"),
            common.getRes(lang, "4UEnclosure_number_tableTitle"),
            common.getRes(lang, "operate_tableTitle")
        ]
    else:
        table_title_2U = common.getRes(lang, "2UEnclosure_number_tableTitle")
        if dae_enc_type == "SMART":
            table_title_2U = common.getRes(lang,
                                           "2UEnclosure_number_tableTitle_ip")
        labels = [
            common.getRes(lang, "cabinet_name_tableTitle"),
            table_title_2U,
            common.getRes(lang, "operate_tableTitle")
        ]

    item_info_dict = {
        "labels": labels
    }
    return item_info_dict


def get_body_item_info(context, lang, support_sas_nvme_mix, support_4U_enc):
    """生成下拉框配置项信息

    :param context: 上下文
    :param lang: 语言
    :param support_4U_enc: 是否支持4U框
    :return:
    """
    if support_sas_nvme_mix:
        labels = [
            "",
            "",
            "",
            common.getRes(lang, "delete_tableLabel")
        ]
    elif support_4U_enc:
        labels = [
            "",
            "",
            common.getRes(lang, "delete_tableLabel")
        ]
    else:
        labels = [
            "",
            common.getRes(lang, "delete_tableLabel")
        ]
    labels.insert(0, '')
    rules = getRules(context)

    item_info_dict = {
        "labels": labels,
        "rules": rules
    }
    return item_info_dict


def getTableColumnItems(context, columnNum, itemInfoDict):
    """获取行的界面配置属性col_list

    :param context: 上下文
    :param columnNum: 配置列数
    :param itemInfoDict: item字典
    :return:
    """
    columnItems = []
    expandType = contextUtil.getItem(context, "expandType")
    is_support_nvme = contextUtil.getItem(context,
                                          "supportSASandNVMeMix", False)
    if is_support_nvme and expandType == "expandDiskBay":
        itemScript = COLUMN_ITEM_SCRIPT[expandType+"NVMe"]
    else:
        itemScript = COLUMN_ITEM_SCRIPT[expandType]

    labels = itemInfoDict.get("labels", [])
    rules = itemInfoDict.get("rules", [])
    if not rules:
        return []

    if columnNum == 5:
        COLUMN_TYPE = COLUMN_ITEM_TYPE_MIX
        COLUMN_PARAM = COLUMN_ITEM_PARAM_MIX
    elif columnNum == 4:
        COLUMN_TYPE = COLUMN_ITEM_TYPE
        COLUMN_PARAM = COLUMN_ITEM_PARAM
    else:
        COLUMN_TYPE = COLUMN_ITEM_TYPE_NO_4U
        COLUMN_PARAM = COLUMN_ITEM_PARAM_NO_4U

    for i in range(columnNum):
        itemId = str(i)
        label = labels[i]
        columnType = COLUMN_TYPE.get(itemId, "")
        param = COLUMN_PARAM.get(itemId, "")
        scriptFile = itemScript.get(itemId, "")
        rule = rules[i]
        rowItem = createTableItem(columnNum, itemId, label, columnType,
                                  scriptFile, param, rule)
        columnItems.append(rowItem)
    return columnItems


def getTableColumnHeadItems(columnNum, itemInfoDict):
    """获取表头界面配置属性col_list

    :param columnNum: 配置列数
    :param itemInfoDict: item字典
    :return:
    """
    rowItems = []
    labels = itemInfoDict.get("labels", [])
    for i in range(columnNum):
        rowId = str(i)
        label = labels[i]
        rowItem = createTableItem(columnNum, rowId, label, "label", "", "",
                                  rule=[])
        rowItems.append(rowItem)

    return rowItems


def getTableRowItem(context, rowId=0, scriptFile=""):
    """获取一行的界面配置信息

    :param context:
    :param rowId:
    :param scriptFile:
    :return:
    """
    support_4U_enc = contextUtil.getItem(context,
                                         "support4UDiskEnclosure", False)
    # 是否支持nvme
    support_sas_nvme_mix = baseUtil.\
        is_support_sas_nvme_mix(context,
                                contextUtil.getItem(context, "productModel"))
    contextUtil.setItem(context, "supportSASandNVMeMix", support_sas_nvme_mix)

    logger = common.getLogger(context.get("logger"), __file__)
    logger.logInfo("support4UDiskEnclosure:" + str(support_4U_enc))
    logger.logInfo("supportSASandNVMeMix:" + str(support_sas_nvme_mix))

    tableHeadFlag = (rowId == 0)
    itemInfoDict = getItemInfoDict(context, tableHeadFlag)
    columnNum = 5 if support_sas_nvme_mix else 4 if support_4U_enc else 3
    if rowId == 0:
        col_list = getTableColumnHeadItems(columnNum, itemInfoDict)
    else:
        col_list = getTableColumnItems(context, columnNum, itemInfoDict)

    colItem = {
        "id": str(rowId),
        "script": scriptFile,
        "columns": col_list
    }
    return colItem
