﻿# -*- coding: UTF-8 -*-
from common import BaseFactory


class Cli:
    # CLI连接
    _cliConn = None

    # 获取一个CLI连接
    def _getCliConn(self, context):
        if None == self._cliConn:
            dev = context["dev"]
            _cliConn = context.createSSH(dev["ip"], dev["sshPort"], dev["user"], dev["pawd"])

    # 执行CLI命令
    def execCli(self, context, strCmd):
        self._getCliConn(context)
        if None == self._cliConn:
            zh = "SSH连接失败"
            sup_zh = "请检查管理PC与阵列的连接"
            en = "english..."
            sup_en = "english..."
            BaseFactory.result.setResult(context, False, zh, sup_zh, en, sup_en)
            return None
        return self._cliConn.execCmd(strCmd)
