﻿# -*- coding: UTF-8 -*-
'''
设置各个FRU，更换时的时间限制
'''
from common import BaseFactory
from common import FuncFactory
from common import config
from cbb.frame.base.config import CONTROLLER_TIME_LIMIT_V5
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

DEFAUL_TIME_LIMIT = "5"
TIME_LIMIT_5600V3_5800V3_6800V3_6900V3_CONTROLLER = "10"
TIME_LIMIT_2800V5_5300V5_5500V5_CONTROLLER = "3"


def execute(context, param):
    try:
        proModel = FuncFactory.getSystemProductType(context)

        if proModel in (BaseFactory.const.SYSMODEL["5X00V3"],
                        BaseFactory.const.SYSMODEL["V3_3U_ENGINE"],
                        BaseFactory.const.SYSMODEL["V3_6U_ENGINE"],
                        BaseFactory.const.SYSMODEL["V3_18000"]):
            param = str(param)
            execfunc = globals()[param]
            if None == execfunc:
                raise Exception("in-existed func: " + param)
            if not callable(execfunc):
                raise Exception("in-callable func: " + param)
            timeLimitInfo = execfunc(context)

            context['retData'] = timeLimitInfo
        else:
            context['retData'] = ""

        return
    except Exception as ex:
        BaseFactory.exception.handler(context, ex)
        return


def power(context):
    selRowKey = "input_selectfru_frutab"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey, restData.Enum.ObjEnum.POWER,
                                           config.POWER_TIME_LIMIT_CONFIG)
    return timeLimit


def bbu(context):
    selRowKey = "input_selectfru_frutab"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey, restData.Enum.ObjEnum.BACKUP_POWER,
                                           config.BBU_TIME_LIMIT_CONFIG)
    return timeLimit


def fan(context):
    selRowKey = "input_selectfru_fanSelectedRow"
    timeLimit = timeLimitFor_Power_BBU_Fan(context, selRowKey, restData.Enum.ObjEnum.FAN, config.FAN_TIME_LIMIT_CONFIG)
    return timeLimit


def manageFanCtrlBoard(context):
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def controller(context):
    timeLimit = DEFAUL_TIME_LIMIT
    productModel = contextUtil.getProductModel(context)
    if productModel in CONTROLLER_TIME_LIMIT_V5:
        timeLimit = TIME_LIMIT_2800V5_5300V5_5500V5_CONTROLLER
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_CONTROLLER_TIME_LIMIT_INFO,
                                    timeLimit)
    appendInfo = BaseFactory.lang.getDesc(context,
                                          FuncFactory.LangKey.CONFIRM_REPLACE_DONE_CONTROLLER_APPEND_TIME_LIMIT_INFO)
    if info is not None and appendInfo:
        info = info + appendInfo
    return info


def disk(context):
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_DISK_TIME_LIMIT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def manageBoard(context):
    proModel = FuncFactory.getSystemProductType(context)
    if proModel == BaseFactory.const.SYSMODEL["5X00V3"]:
        return ""
    else:
        info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                        DEFAUL_TIME_LIMIT)
        return info


def manageBoardPrecheckInfo(context):
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_MANAGEBOARD_TIME_LIMIT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def defaultTimeLimit(context):
    '''
    DSP:返回默认的限制时间
    '''
    info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                    DEFAUL_TIME_LIMIT)
    return info


def getFruEncType(context, fruInfo):
    if None == fruInfo:
        return "--"
    logicType = restUtil.Tlv2Rest.getRecordValue(fruInfo, restData.Hardware.Enclosure.LOGIC_TYPE)

    if logicType == restData.Enum.EncLogicTypeEnum.EXP:
        return "EXP"
    elif logicType == restData.Enum.EncLogicTypeEnum.CTRL:
        return "CTRL"
    elif logicType == restData.Enum.EncLogicTypeEnum.DSW:
        return "DSW"
    else:
        return "--"


def getFruEncHight(context, fruInfo):
    if None == fruInfo:
        return "--"

    height = restUtil.Tlv2Rest.getRecordValue(fruInfo, restData.Hardware.Enclosure.HEIGHT)
    logicType = restUtil.Tlv2Rest.getRecordValue(fruInfo, restData.Hardware.Enclosure.LOGIC_TYPE)
    if logicType == restData.Enum.EncLogicTypeEnum.CTRL:
        return str(height)
    return "--"


def isHighDensityEnc(context, fruType, fruId):
    expEncType = FuncFactory.getExpEncType(context, fruType, fruId)
    if expEncType == BaseFactory.const.EXPENCMODEL["T_4U75"]:
        return "high-density"
    return "--"


def timeLimitFor_Power_BBU_Fan(context, selRowKey, fruType, specDict):
    try:
        selRow = BaseFactory.json.toDict(context.get(selRowKey))
        fruInfo = FuncFactory.getFruParentEncRec(context, fruType, selRow["id"])

        encType = getFruEncType(context, fruInfo)
        encHight = getFruEncHight(context, fruInfo)
        isHighDensity = "--"
        if "EXP" == encType:
            isHighDensity = isHighDensityEnc(context, fruType, selRow["id"])

        key = (encType, encHight, isHighDensity)
        BaseFactory.log.info(context, "The dict key is " + str(key))

        # 没有配置时取默认值 防止界面卡死
        timeLimit = specDict.get(key, DEFAUL_TIME_LIMIT)
        isFan2U = FuncFactory.is2U_Fan(context, fruType, selRow["id"])
        if isFan2U and fruType is restData.Enum.ObjEnum.FAN:
            info = BaseFactory.lang.getDesc(context,
                                            FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO_FOR_BUNDLE_FRU,
                                            timeLimit)
            return info
        else:
            info = BaseFactory.lang.getDesc(context, FuncFactory.LangKey.CONFIRM_REPLACE_DONE_TIME_LIMIT_DEFAULT_INFO,
                                            timeLimit)
            return info
    except Exception as e:
        BaseFactory.log.error(context, "An exception occured when exec Tlv.execmd." + str(e))
        return None
