﻿# -*- coding: UTF-8 -*-
import os

from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.base import baseUtil


def get_image_path(context):
    """获取图片路径

    :param context:
    :return:
    """
    lang = contextUtil.getLang(context)
    product_model = contextUtil.getProductModel(context)

    if baseUtil.is_ocean_protect(product_model):
        image_file = "qr_code_protect_%s.jpg" % lang
    elif baseUtil.is_computing_dev(product_model):
        image_file = "qr_code_computing_%s.jpg" % lang
    elif baseUtil.is_micro_dev(product_model):
        image_file = "qr_code_micro_%s.jpg" % lang
    elif baseUtil.is_new_oceanstor(product_model):
        image_file = "qr_code_new_oceanstor_%s.jpg" % lang
    elif baseUtil.isDoradoV6Dev(product_model):
        image_file = "qr_code_v6_%s.jpg" % lang
    else:
        image_file = "qr_code_v5_%s.jpg" % lang

    cur_dir = context.get("importRootDir")
    cur_dir_par = cur_dir[:cur_dir.rfind(os.path.sep)]
    image_path = os.path.join(cur_dir_par[:cur_dir_par.rfind(os.path.sep)],
                              "resource", "image", image_file)
    return image_path


def get_url_link(context):
    """获取视频链接

    :param context:
    :return:
    """
    lang = contextUtil.getLang(context)
    product_model = contextUtil.getProductModel(context)

    if baseUtil.is_ocean_protect(product_model):
        res_key = "guide_video_link_protect"
    elif baseUtil.is_computing_dev(product_model):
        res_key = "guide_video_link_computing"
    elif baseUtil.is_micro_dev(product_model):
        res_key = "guide_video_link_micro"
    elif baseUtil.is_new_oceanstor(product_model):
        res_key = "guide_video_link_new_oceanstor"
    elif baseUtil.isDoradoV6Dev(product_model):
        res_key = "guide_video_link_v6"
    else:
        res_key = "guide_video_link_v5"
    return FuncFactory.getRes(lang, res_key)


def get_guide_topic_info(context):
    """获取二维码窗口的基本属性

    :param context: 工具上下文
    :return:
    """
    lang = contextUtil.getLang(context)
    image_path = get_image_path(context)

    # 指导显示框的基本属性
    if lang == "zh":
        dialog_height = "470"
        dialog_width = "470"
    else:
        dialog_height = "490"
        dialog_width = "470"

    url_link = get_url_link(context)
    guide_topic_info_dict = {
        'startimagepath': image_path,
        'imagepath': image_path,
        'dialogheight': dialog_height,
        'dialogwidth': dialog_width,
        'dialogtitle': FuncFactory.getRes(lang, "guide_video_title"),
        'dialogdesc': FuncFactory.getRes(lang, "guide_video_desc", url_link),
    }

    return guide_topic_info_dict


def execute(context):
    """打开二维码图片窗口

    :param context:
    :return:
    """
    try:
        flag = "#imagelink#"  # 链接标记，便于框架识别
        guide_topic_info_dict = get_guide_topic_info(context)

        guide_topic_info = BaseFactory.json.dictToStr(guide_topic_info_dict)
        guide_topic_info = guide_topic_info.replace("\\", "\\\\")

        context["doc_link"] = flag + guide_topic_info
        BaseFactory.log.info(context,
                             "create video guide "
                             "info = %s" % context["doc_link"])
        BaseFactory.result.setResultPass(context)
        return

    except Exception as ex:
        BaseFactory.exception.handler(context, ex)
        return
