﻿# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

# 缓存当前风扇key值
ALL_RUNNING_FAN = "allRunningFan"


def execute(context, preCheck=True):
    """获取所有风扇信息，前后一致性比较

    :param context(dict): python上下文
    :param preCheck(bool): True-更换前检查 False-更换后检查
    :return:
    """
    # 更换前备份信息
    if preCheck:
        # 获取所有风扇信息
        curRunningFan = getCurrentFan(context)
        BaseFactory.log.info(context, "running fan before is :%s" % str(curRunningFan))
        if not curRunningFan:
            BaseFactory.result.setResultPass(context)
            return
        # 保存信息
        BaseFactory.persist.setModule(context, ALL_RUNNING_FAN, curRunningFan)
        BaseFactory.result.setResultPass(context)
        return
    # 更换后比对信息
    else:
        BaseFactory.log.info(context, "====Check fan ==== begin")
        # 获取已保存信息
        runningFanBefore = BaseFactory.persist.getModule(context, ALL_RUNNING_FAN)

        if not runningFanBefore:
            BaseFactory.result.setResultPass(context)
            return
        BaseFactory.log.info(context, "running fan before is :%s" % str(runningFanBefore))

        # 获取最新信息
        runningFanCur = getCurrentFan(context)
        BaseFactory.log.info(context, "running fan after is :%s" % str(runningFanCur))

        abnormalLocs = [location for location in runningFanBefore if location not in runningFanCur]

        if abnormalLocs:
            BaseFactory.result.setResultFailByKey(context, FuncFactory.LangKey.FAN_CHECK_CONSISTENT, None,
                                                  ", ".join(abnormalLocs))
            BaseFactory.log.info(context, "====Check fan ==== fail end")
            return

        BaseFactory.result.setResultPass(context)
        BaseFactory.log.info(context, "====Check fan ==== pass end")
        return


def getCurrentFan(context):
    """获取当前状态正常的所有风扇

    :param context:
    :return:
    """
    recs = FuncFactory.getFruListInfo(context, restData.Enum.ObjEnum.FAN)
    runningCond = restUtil.Tlv2Rest.getCondition(restData.Hardware.Fan.RUNNING_STATUS,
                                               restData.Enum.ConditionTypeEnum.EQ,
                                               restData.Enum.RunningStatusEnum.RUNNING)
    healthCond = restUtil.Tlv2Rest.getCondition(restData.Hardware.Fan.HEALTH_STATUS,
                                                 restData.Enum.ConditionTypeEnum.EQ,
                                                 restData.Enum.RunningStatusEnum.NORMAL)
    conditions = restUtil.Tlv2Rest.getConditionList(runningCond, healthCond)
    runningFan = restUtil.Tlv2Rest.filter(recs, conditions)
    locs = map(lambda x: restUtil.Tlv2Rest.getRecordValue(x, restData.PublicAttributes.LOCATION), runningFan)
    return locs
