#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/09/16
@file: check_enclosure_redundant_cable.py
@function:
@modify:
"""

from cbb.frame.rest.restUtil import CommonRest
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData

ERR_CODE_KEY = {"64424902700":
                FuncFactory.LangKey.DISKENC_ENCLOSURE_REDUNDANT_CABLE_ERR}


def execute(context):
    # 检查是否有框级冗余下线缆告警
    alarm_records = get_valid_alarms(context)
    if not alarm_records:
        BaseFactory.result.setResultPass(context)
        return
    err_key, err_params = get_alram_err_msg(alarm_records)
    if err_key and err_params:
        BaseFactory.result.setResultFailByKey(context, err_key, err_params)
        return

    BaseFactory.result.setResultPass(context)
    return


def get_valid_alarms(context):
    """检查告警

    :param rest:
    :return:
    """
    rest = contextUtil.getRest(context)
    alarm_records = []
    records = CommonRest.getAlarms(rest)
    if not records:
        return alarm_records
    for record in records:
        alarm_id = str(CommonRest.getRecordValue(record, restData
                                                 .RestCfg.Alarm.EVENTID))
        BaseFactory.log.info(context, "get alarm id:%s" % alarm_id)
        if alarm_id in ERR_CODE_KEY:
            alarm_records.append(record)
    return alarm_records


def get_alram_err_msg(alarm_records):
    """获取告警信息

    :param alarm_records 告警信息
    :return: 告警KEY，参数列表
    """
    err_key = ""
    for record in alarm_records:
        alarm_id = str(
            CommonRest.getRecordValue(record, restData.RestCfg.Alarm.EVENTID))
        _, enc_id, enc_sn = CommonRest\
            .getRecordValue(record,
                            restData.RestCfg.Alarm.EVENTPARAM).split(",")
        err_key = ERR_CODE_KEY.get(alarm_id, "")
        return err_key, (enc_id, enc_sn)

    return err_key, ()
