﻿# -*- coding: UTF-8 -*-
import json

from cbb.business.operate.fru.common import common
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil


def execute(context, select_id):
    """
    :param context: 上下文
    :param select_id: 保持数据的ID
    :return:
    """
    lang = contextUtil.getLang(context)
    log = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        all_abnormal_pools = get_abnormal_pools(context)
        pools = get_checked_pools(context, select_id)
        cur_abnormal_pools = list(set(all_abnormal_pools) & set(pools))
        if cur_abnormal_pools:
            cur_abnormal_pools.sort()
            pool_msg = ",".join(cur_abnormal_pools)
            msg, sug = common.getMsg(
                lang, "check.multi.pools.abnormal", suggestionArgs=pool_msg
            )
            contextUtil.setResult(context, False, msg, sug)
            return
        contextUtil.setResult(context, True, "", "")
        return
    except Exception as e:
        log.error("check domain error:%s" % str(e))
        msg, sug = common.getMsg(lang, "get.domain.error")
        contextUtil.setResult(context, False, msg, sug)
        return


def get_checked_pools(context, select_id):
    pools = set()
    disks = json.loads(context.get(select_id))
    for disk in disks:
        pools.add(disk.get("poolID"))

    checked_pools = list(pools)
    checked_pools.sort()
    return checked_pools


def get_abnormal_pools(context):
    abnormal_pools = []
    rest = contextUtil.getRest(context)
    pool_recs = restUtil.CommonRest.getDiskDomains(rest)
    for rec in pool_recs:
        pool_id = restUtil.CommonRest.getRecordValue(
            rec, restData.RestCfg.PublicAttributes.ID
        )
        running_status = restUtil.CommonRest.getRecordValue(
            rec, restData.RestCfg.PublicAttributes.RUNNING_STATUS
        )
        health_status = restUtil.CommonRest.getRecordValue(
            rec, restData.RestCfg.PublicAttributes.HEALTH_STATUS
        )

        if health_status in [restData.Enum.HealthStatusEnum.DEGRADE,
                             restData.Enum.HealthStatusEnum.FAULT] or \
                running_status not in [restData.Enum.RunningStatusEnum.ONLINE]:
            abnormal_pools.append(pool_id)
    return abnormal_pools
