# coding=utf-8
"""
@version: Toolkit V200R006C00
@time: 2020/09/24
@file: checkRedundantSwitch.py
@function:检查冗余交换机链路端口问题功能
@modify:
"""

from cbb.frame.context import contextUtil
import cbb.business.operate.fru.common.FuncFactory as FuncFactory
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.business.operate.fru.common import LoopCheckFactory
import cbb.business.operate.fru.common.BaseFactory as BaseFactory


def check_port_for_all_type(context, all_right_port_recs, ports_connect_dsw):
    is_kunpeng_high = contextUtil.getItem(context, "is_kunpeng_high", False)
    if is_kunpeng_high:
        # 获取ETH口所在接口卡的父器件类型 控制器或者控制
        if not check_port_kunpeng_high(context, all_right_port_recs,
                                       ports_connect_dsw):
            return False
    else:
        # "Dorado"及"融合中低端设备",无法查询控制框location，需采用不同逻辑
        # 控制框和接口卡和端口呈正确数量关系
        if not check_port_low_mid_end(context, ports_connect_dsw):
            return False

    return True


def get_enclosure_num(context):
    all_enclosure_info = FuncFactory\
        .getFruListInfo(context, restData.Enum.ObjEnum.ENCLOSURE)
    condition2 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Enclosure.LOGIC_TYPE,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.EncLogicTypeEnum.CTRL)
    condition_list = restUtil.Tlv2Rest.getConditionList(condition2)
    ctrl_enclosure_info = restUtil.Tlv2Rest.filter(all_enclosure_info,
                                                   condition_list)
    ctrl_enc_num = len(ctrl_enclosure_info)
    return ctrl_enc_num


def get_ip_scale_out_intf_num(context, intf_list):
    all_intf_info = FuncFactory.getFruListInfo(
        context, restData.Enum.ObjEnum.INTF_MODULE)
    condition2 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.IntfModule.MODEL,
        restData.Enum.ConditionTypeEnum.EQOR, intf_list)
    condition_list = restUtil.Tlv2Rest.getConditionList(condition2)
    ip_scale_out_intf = restUtil.Tlv2Rest.filter(
        all_intf_info, condition_list)
    ip_scale_out_intf_num = len(ip_scale_out_intf)
    return ip_scale_out_intf_num


def get_ip_scale_port_num(all_right_port_recs):
    ip_scale_out_port_num = 0
    for port_info in all_right_port_recs:
        port_location = restUtil.Tlv2Rest.getRecordValue(
            port_info, restData.PublicAttributes.LOCATION)
        if port_location.split(".")[-1] == "P0":
            ip_scale_out_port_num += 1
    return ip_scale_out_port_num


def get_ctrl_num(context):
    all_controller_info = FuncFactory \
        .getFruListInfo(context, restData.Enum.ObjEnum.CONTROLLER)
    ctrl_num = len(all_controller_info)
    return ctrl_num


def check_port_kunpeng_high(context, all_right_port_recs,
                            ports_connect_dsw):
    # 获取ETH口所在接口卡的父器件类型 控制器或者控制框
    one_port = all_right_port_recs[0]
    intf_card_id = restUtil.Tlv2Rest.getRecordValue(
        one_port, restData.PublicAttributes.PARENT_ID)
    intf_card_type = restUtil.Tlv2Rest.getRecordValue(
        one_port, restData.PublicAttributes.PARENT_TYPE)
    parent_info = FuncFactory.get_parent_info(
        context, intf_card_type, intf_card_id)
    parent_type = restUtil.Tlv2Rest.getRecordValue(
        parent_info, restData.PublicAttributes.PARENT_TYPE)
    # 获取所有父器件类型的器件列表
    normal_parent_type_fru = LoopCheckFactory.Loop\
        .get_normal_fru_by_type(context, parent_type)
    # 检查ETH口是否与所有的控制器或者控制框相连
    if not LoopCheckFactory.Loop.is_connect_with_all_fru(
            ports_connect_dsw, normal_parent_type_fru):
        return False
    return True


def check_port_low_mid_end(context, ports_connect_dsw):
    # Dorado及融合中低端设备,无法查询控制框location，需采用不同逻辑
    # 控制框和接口卡和端口呈正确数量关系
    ctrl_num = get_ctrl_num(context)
    intf_list = [restData.Enum.IntfModelEnum.SO_4X25G_RDMA_MODULE,
                 restData.Enum.IntfModelEnum.SO_4X25G_RDMA_MODULE_LC,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_LC,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_LCS,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_HCS,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_LC_SAS,
                 restData.Enum.IntfModelEnum.SO_4X25G_RDMA_MODULE_LC_SAS,
                 restData.Enum.IntfModelEnum.SO_4X25G_RDMA_MODULE_LC_SAS_2399,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_LC_SAS_2405,
                 restData.Enum.IntfModelEnum.SO_2X200G_RDMA_MODULE_2444,
                 restData.Enum.IntfModelEnum.SO_2X200G_RDMA_MODULE_2445,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_2457,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_2458,
                 restData.Enum.IntfModelEnum.SO_2X100G_RDMA_MODULE_HC]
    ip_scale_out_intf_num = get_ip_scale_out_intf_num(context, intf_list)
    ip_scale_out_port_num = len(ports_connect_dsw)
    BaseFactory.log.info(context,
                         "ctrl_num:" + str(ctrl_num) +
                         "  ip_scale_out_intf_num:" +
                         str(ip_scale_out_intf_num) +
                         "  ip_scale_out_port_num" +
                         str(ip_scale_out_port_num))
    # 需维持数量关系：控制器=IPSCALEOUT接口卡=IPSCALEOUT端口（连接冗余交换机平面）数量
    if not (ctrl_num == ip_scale_out_intf_num and
            ip_scale_out_port_num == ip_scale_out_intf_num):
        return False
    return True
