#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/07/27
@file: check_sed_msid_risk.py
@function:
@modify:
"""

from cbb.business.operate.checkitems import check_sed_msid_risk
from cbb.business.operate.checkitems.check_sed_msid_risk import errCode
from cbb.frame.cli import cliUtil


def execute(context):
    """加密盘与产品读取MSID算法冲突,导致接盘失败
    @Id bdm_check_sed_msid_risk_product_version
    @EngDec check product version with sed msid risk

    :param context:上下文
                    需要字段：
                    cli
                    lang
                    logger
                    expDiskList
    :return:
        Ret：是否通过， 回显， 错误信息
    """
    try:

        exp_disk_list = context.get("expDiskList")
        logger = context.get("logger")
        lang = context.get("lang")

        exp_disk_types = []
        if exp_disk_list:
            for disk_cfg in exp_disk_list:
                logger.info(str(disk_cfg.get("diskModel")))
                disk_model = str(disk_cfg.get("diskModel"))
                exp_disk_types.append(disk_model)

        ret = check_sed_msid_risk.execute(context, exp_disk_types,
                                          context.get("CLI_CONNECTION"))

        right_version = ""
        right_patch = ""
        if ret[0]:
            logger.info("the checkitem pass")
            return (True, "", "")
        elif ret[2] == errCode.V600_PATCH_NOT_MEET:
            # 如果为 V6.0.0 但热补丁小于 SPH7
            logger.info("version V6.0.0 patch not meet")
            right_version += "OceanStor Dorado V6 6.0.0"
            right_patch += "SPH7"
        else:
            # 如果为V6.0.RC1 或 V6.0.1 但热补丁小于 SPH1
            logger.info("version V6.0.RC1 or V6.0.1 patch not meet")
            right_version += "OceanStor Dorado V6 6.0.1"
            right_patch += "SPH1"

        errMsg = cliUtil.getMsg(lang, "prod.patch.version.too.old",
                                (ret[3], ret[4],
                                 right_version, right_patch))

        return (False, ret[1], errMsg)
    except Exception as ex:
        raise Exception(ex)
