# -*- coding: UTF-8 -*-


DISK_UPGRADE_SUCCESS_RET_LIST = ["Upgrade success"]
DISK_UPGRADE_NONEED_RET_LIST = ["The disk firmware is already the latest version",
                                "Upgrade coffer disk is forbidden"]
TIME_OUT = "TOOLKIT_SEND_CMD_TIME_OUT"

DISK_UPGRADE_NOFILE_RET_LIST = ["Error: No such file or directory.",
                                "Error: The SFTP user name or password is incorrect.",
                                "Error: Communicating with the device failed.",
                                "Failed to verify the upgrade package."
                                ]


class UPD_STATUS():
    SUCCESS = 0
    FAIL = 1
    ERROR = 2  # 升级出错
    NONEED = 3  # 不需要升级
    PRECHECK_FAIL = 4  # 升级前检查不通过
    Retry = 5


class UPD_ITEM_STATUS():
    # 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过，5忽略，6暂停
    WAITING = 0
    CHECKING = 1
    ALARM = 2
    SUCCEEDED = 3
    FAILED = 4
    IGNORE = 5
    PAUSED = 6
    NOSUPPORT = 7
    NOTPASS = 8


class UPD_SELE_DISK_TYPE():
    # 0未选择, 1系统全部硬盘, 2自定义选择硬盘
    NO_SELECT = "NO_SELECT"
    ALL_DISK = "ALL_DISKS"
    CUSTOM_DISK = "CUSTOM_DISKS"


class IMPORT_PKG_MODE():
    # 硬盘升级导包模式：0表示不支持导包；1表示支持手动导包；2表示支持独立导包；
    NO_PKG = 0
    SIMPLE_PKG = 1
    MIX_PKG = 2


class DISK_UPGRADE_MODE():
    ALL = 1
    SINGLE = 2
    MULTI = 3


class CheckStatus:
    WAITING = 0
    CHECKING = 1
    ALARM = 2
    SUCCEEDED = 3
    FAILED = 4
    IGNORE = 5
    PAUSED = 6
    NOSUPPORT = 7
    NOPASS = 8
    OVER = 9


UPD_DISK_TIME = 20 * 60  # 升级硬盘的超时时间
RECONTRUCTION_TIME = 20 * 60  # 硬盘域重构时间
DISKPOOL_OBJ_TYPE = 266  # 硬盘域的枚举值

# 硬盘固件包上传路径（服务端）
SERVER_UPGRADE_PKG_DIR = '/home/permitdir/'

# 硬盘固件包打包成补丁包后的临时目录名
FW_TO_PACKAGE_DIR_TEMP = 'tmp'

# 硬盘固件包压缩格式
FW_COMPRESS_EXT = '.tgz'

# 硬盘固件包名称
FW_PKG_NAME = 'diskfw.tgz'

PATCH_CONF_FILE = 'packages\\DiskUpgrade\\products\\V3V300R003C00\\configuration\\patch.conf'

CHECK_ITEM_SPLIT_FLAG = "    "  # 四个空格
CHECK_START_FLAG = "Check Item Name"
CHECK_ITEM_PASS = "pass"
CHECK_ITEM_RESULT = "Result"
NEED_RETRY_CHECK_ITEMS = [
    "SysResourceCheck",
    "DiskUsageCheck",
    "ISDiskInDiagnose",
    "ISFrontBandWidthEnough",
    "GetPoolStatus",
]
CHECK_ITEMS = [
    "SysFaultCheck",
    "CheckMemoryAbnormality",
    "AlarmCheck",
    "LunDestoryCheck",
    "SysResourceCheck",
    "DiskUsageCheck",
    "ISDiskInDiagnose",
    "ISFrontBandWidthEnough",
    "ISRssStatusSupportOnline",
    "SysCompatibleCheck",
    "IsDoubleCtrlCheck",
    "ISSameVersion",
    "SysSoftwareCompatibleCheck",
    "SingleLinkCheck",
    "CheckPcieLink",
    "GetPoolStatus",
    "DiskUpgradeUsageCheck",
    "CheckCCDBStatus",
]

CHECK_NOPASS_END = ".nopass"

# 补丁包大小+80MB < 空闲空间大小
# 单位是MB
MEM_SIZE = 80
