# coding:utf-8
"""
产品特性相关通用配置文件。
"""
from cbb.common.conf.switch_config import CE6881
from cbb.frame.base import config
from cbb.frame.rest import restData
from utils import Products


ARM_DEVS_SUPPORT_NAS = ("2200 V3", "2600 V3", "2600F V3",
                        "5110 V5", "5110F V5", "5100K V5",
                        "5210 V5", "5210F V5", "5200K V5",
                        "5300 V5",
                        "5500 V5 Elite",
                        "2810 V5",
                        "5310 V5", '5310F V5',
                        "5510 V5", '5510F V5',
                        "5610 V5", '5610F V5',
                        "5810 V5", '5810F V5',
                        )

# V5 Kunpeng新硬件国内版、海外版、安可版本枚举值一致，显示型号不同
# 此字典用于扩容评估获取扩控规格，区别于老硬件V5
NEW_ARM_DEVS_DIFF_PRODUCT_STRING = {
    "2810 V5": ["2810 V5", "2800 V5", "2800K V5"],
    "5110 V5": ["5110 V5 Enhanced", "5120 V5"],
    "5110F V5": ["5110F V5 Enhanced"],
    "5210 V5": ["5210 V5 Enhanced", "5220 V5"],
    "5210F V5": ["5210F V5 Enhanced"],
    "5310 V5": ["5310 V5", "5300 V5", "5300K V5"],
    "5310F V5": ["5310F V5", "5300F V5"],
    "5510 V5": ["5510 V5", "5500 V5", "5500K V5"],
    "5510F V5": ["5510F V5", "5500F V5"],
    "5610 V5": ["5610 V5", "5600 V5", "5600K V5"],
    "5610F V5": ["5610F V5", "5600F V5"],
    "5810 V5": ["5810 V5", "5800 V5", "5800K V5"],
    "5810F V5": ["5810F V5", "5800F V5"],
    "6810 V5": ["6810 V5", "6800 V5", "6800K V5"],
    "6810F V5": ["6810F V5", "6800F V5"],
    "18510 V5": ["18510 V5", "18500 V5", "18500K V5"],
    "18510F V5": ["18510F V5", "18500F V5"],
    "18810 V5": ["18810 V5", "18800 V5", "18800K V5"],
    "18810F V5": ["18810F V5", "18800F V5"],
}

# 扩容评估硬盘域新增层级硬盘数量规格检查型号列表：中低端
EXPAND_TIER_CHECK_PDT_MODEL = ["2100 V3", "2200 V3", "2200 V3 Enhanced",
                               "2600 V3", "2600 V3 Enhanced",
                               "2600 V3 for Video", "2800 V3", "5300 V3",
                               "5300 V5 Enhanced", "5500 V3", "5600 V3",
                               "5800 V3", "6800 V3", "2800 V5",
                               "5300 V5", "5310 V5", "5310K V5",
                               "5500 V5", "5510 V5", "5510K V5",
                               "5600 V5", "5610 V5", "5610K V5",
                               "5800 V5", "5810 V5", "5810K V5",
                               "6800 V5", "6810 V5", "6810K V5",
                               "5500 V5 Elite", "2600 V5", "5110 V5 Enhanced",
                               "5120 V5", "5110F V5 Enhanced", "5210 V5 Enhanced",
                               "5220 V5", "5210F V5 Enhanced", "2210",
                               "2220", "2200 V5"]

# 扩容评估硬盘域新增层级硬盘数量规格检查型号列表：高端
EXPAND_TIER_CHECK_PDT_MODEL_HIGH = ["18500 V3", "18800 V3",
                                    "18500 V5", "18510 V5", "18510K V5",
                                    "18800 V5", "18810 V5", "18810K V5"]

# 线缆连接告警事件ID
CABLE_CONNCT_ALM_EVENT_IDS = [
    "64424902687", 	# 端口上的线缆连接错误
    "64424902688",  # 端口间的线缆连接错误
    "64424902689",  # 端口间线缆未按标准组网连接
    "64424902690",  # 端口上线缆未连接
    "64424902691",  # 端口间线缆未连接
]

# 线缆连接告警事件ID
CABLE_CONNCT_ALM_EVENT_IDS_FOR_NAS = [
    "64424902687", 	# 端口上的线缆连接错误
    "64424902696",  # 端口间的线缆连接错误
    "64424902697",  # 端口间线缆未按标准组网连接
    "64424902690",  # 端口上线缆未连接
    "64424902698",  # 端口间线缆未连接
]

# 框超温告警
ENC_TEMPERATURE_ALM_IDS = [
    "0xF0CE0007", # 框温度低于规格限制
    "0xF0CE0008", # 控制框温度超过规格限制
    "0xF0CE0009", # 控制框温度严重超过规格限制
    "0xF0CE0005", # 硬盘框温度超过规格限制
    "0xF0CE000A" # 硬盘框温度严重超过规格限制
]

# 框高对应的单框最大控制器数量
ENC_HEIGHT_TO_CTRL_NUM = {
    2: 2,
    3: 2,
    4: 4,
    6: 4
}

# 需要提示拔出以太网卡的场景：key-原集群控制器数量，value-控制框号
ORI_CTRL_TO_ENC_NUM = {
    2: "0",
    6: "1"
}

# 高端每控冗余风扇规格
HIGH_END_RED_FAN_NUM_PER_CTRL = 6

# V5/V6新硬件中低高端每控风扇数量
PDT_FAN_NUM_PER_CTRL = {
    "low_end": 4,
    "mid_end": 6,
    "high_end": 7
}

CTRL_ENC_TEMPERATURE_ALM = {
    # V5 5X10
    restData.Enum.ProductModeEnum.V5_2810: 48,

    restData.Enum.ProductModeEnum.V5_5210: 48,
    restData.Enum.ProductModeEnum.V5_5210F: 48,

    restData.Enum.ProductModeEnum.V5_5310: 48,
    restData.Enum.ProductModeEnum.V5_5310F: 48,

    restData.Enum.ProductModeEnum.V5_5510: 48,
    restData.Enum.ProductModeEnum.V5_5510F: 48,

    restData.Enum.ProductModeEnum.V5_5610: 48,
    restData.Enum.ProductModeEnum.V5_5610F: 48,

    restData.Enum.ProductModeEnum.V5_5810: 48,
    restData.Enum.ProductModeEnum.V5_5810F: 48,

    # Dorado V6
    restData.Enum.ProductModeEnum.Dorado3000_V6_SAS: 48,
    restData.Enum.ProductModeEnum.Dorado3000_V6_IPSAS: 48,

    restData.Enum.ProductModeEnum.Dorado5000_V6_SAS: 48,
    restData.Enum.ProductModeEnum.Dorado5000_V6_NVMe: 48,

    restData.Enum.ProductModeEnum.Dorado5000_V6_IPSAS: 48,
    restData.Enum.ProductModeEnum.Dorado6000_V6_SAS: 48,

    restData.Enum.ProductModeEnum.Dorado6000_V6_NVMe: 48,
    restData.Enum.ProductModeEnum.Dorado6000_V6_IPSAS: 48,
}

SLOT_KEY = "slot"
INTERF_MODEL_KEY = "interfModel"

# V5/V6新硬件交换接口卡类型及槽位规则
NEW_SCALEOUT_INTF_SLOT_CONFIG = {
    tuple(config.ARM_LOWEND_ENHANCED): {
        SLOT_KEY: ["IOM0"],
        INTERF_MODEL_KEY:
            {
                # 直连组网：4端口 SO 25Gb RDMA I/O模块
                "direct": [2309, 2338, 2361]
            }
    },
    tuple(config.DORADO_DEVS_V6_LOW + config.ARM_LOWEND_NEW): {
        SLOT_KEY: ["IOM1"],
        INTERF_MODEL_KEY:
            {
                # 直连组网：4端口 SO 25Gb RDMA I/O模块
                "direct": [2309, 2338, 2361],
                # 交换机组网：4端口 SO 25Gb RDMA I/O模块
                "switch": [2338, 2361]
            }
    },
    tuple(config.DORADO_DEVS_V6_MID + config.ARM_MID_END_NEW): {
        SLOT_KEY: ["IOM2"],
        INTERF_MODEL_KEY:
            {
                # 直连组网：4端口 SO 25Gb RDMA I/O模块
                "direct": [2309, 2338, 2361],
                # 交换机组网：4端口 SO 25Gb RDMA I/O模块
                "switch": [2338, 2361]
            }
    },
    tuple(config.DORADO_DEVS_V6_HIGH + config.ARM_HIGH_END_NEW): {
        SLOT_KEY: ["H3", "L3", "H10", "L10"],
        INTERF_MODEL_KEY:
            {
                # 高端直连和交换组网都使用2端口 SO 100Gb RDMA I/O模块
                "direct": [2318, 2322, 2351, 2357, 2362, 2363],
                "switch": [2351, 2357, 2362, 2363]
            }
    }
}

# V6 & V5R7C60新硬件中低端电源适应号与控制器平面对应关系
POWER_CTRL_MID_LOW_END = {
    "0": "A",
    "1": "B",
}
DAE_POWER_ON_SECS = {
    'SAS': 5 * 60,
    'SMART': 25 * 60,
}
# IP硬盘框配置
IP_DISK_ENCS = [restData.Enum.EnclosureModelEnum.EXP_IPNVMe_2U_36,
                restData.Enum.EnclosureModelEnum.EXP_IPSAS_2U_12,
                restData.Enum.EnclosureModelEnum.EXP_IPSAS_2U_25]

# IP框默认级联深度
DEF_SMART_DEPTH = 2

# IP硬盘框单个级联板下的风扇数量
SINGLE_IP_EXP_FAN_NUM = 4

# DoradoV6 SAS形态背板型号
SAS_INTERNAL_PDT_MODEL_TUPLE = (
    'D3000V6', 'D3000V6_C', 'D3000V6_F', 'D3000V6_C_F', 'D5000V6', 'D5000V6_C', "D2000V6_C", "D2100V6_C", "D2020V6_C",
    'D6000V6', 'D8000V6', 'D8000V6_C', 'D18000V6', 'D18000V6_C', '2910V6', '2910V6_XPU'
    'D5300V6', 'D5300V6_C', 'D5300V6_F', 'D5300V6_C_F', 'D5500V6', 'D5500V6_C',
    'D5600V6', 'D5800V6', 'D6800V6', 'D5600V6_S', 'D5600V6_S_H', 'D5600V6_X', 'D6800V6_C_X', "E8000",
    'D6800V6_C', 'D18500V6', 'D18500V6_C', 'D18800V6', 'D18800V6_C',
    'D6800V6_2P', 'D6800V6_C_2P', 'D6800V6_C_X_2P', 'D8000V6_2P',
    'D8000V6_C_2P', 'D18500V6_2P', 'D18500V6_C_2P', 'D5600V6_X_H',
    'D6800V6_C_X_H', 'D5500V6_C_X', 'D5500V6_C_X_H', 'D5600KV6_X', "D2000V6_C_X_H", "D2000V6_C_X",
    'D5600KV6_X_H', 'D6800KV6_C_X', 'D6800KV6_C_X_H',
    "18510_C", "18500K_C", "18810_C", "5810H", "D5600V6_X_H_1P", "D5600KV6_X_H_1P", "D5600V6_X_1P", "D5600KV6_X_1P")
# DoradoV6 IP SAS形态背板型号
IP_SAS_INTERNAL_PDT_MODEL_TUPLE = (
    'D5000V6_I', 'D5000V6_I_C', 'D6000V6_I', 'D8000V6_I', 'D8000V6_I_C',
    'D18000V6_I', 'D18000V6_I_C',
    'D5300V6_I', 'D5500V6_I', 'D5500V6_I_C', 'D5600V6_I', 'D5800V6_I',
    'D6800V6_I', 'D6800V6_I_C', 'D18500V6_I', 'D18500V6_I_C' 'D18800V6_I',
    'D18800V6_I_C', 'D6800V6_I_2P', 'D6800V6_I_C_2P', 'D8000V6_I_2P',
    'D8000V6_I_C_2P', 'D18500V6_I_2P', 'D18500V6_I_C_2P')
# DoradoV6 IP NVMe形态背板型号
IP_NVME_INTERNAL_PDT_MODEL_TUPLE = (
    'D5000V6_N', 'D3000V6_N_C', 'D3000V6_N_C_F', 'D5000V6_N_C', 'D6000V6_N',
    'D8000V6_N', 'D8000V6_N_C', 'D18000V6_N', 'D18000V6_N_C',
    'D5300V6_N', 'D5300V6_N_C', 'D5300V6_N_C_F', 'D5500V6_N',
    'D5500V6_N_C', 'D5600V6_N', 'D5800V6_N',
    'D6800V6_N', 'D6800V6_N_C', 'D18500V6_N', 'D18500V6_N_C', 'D18800V6_N',
    'D18800V6_N_C', 'D18800KV6_N', 'D18800KV6_N_C', 'D6800V6_N_2P',
    'D6800V6_N_C_2P', 'D8000V6_N_2P', 'D8000V6_N_C_2P', 'D18500V6_N_2P',
    'D18500V6_N_C_2P', "D5600KV6_N", "18510_N_C", "18500K_N_C", "18810_N_C", 'D6800V6_N_C_X')


# Dorado V3用户有效容量规格: 型号--控制器内存规格--VRC版本
CHECK_DEV_CAPACITY = {
    "Dorado3000 V3": {
        96: {"V300R002C10": 500000, "V300R002C20": 500000}
    },
    "Dorado5000 V3": {
        128: {"V300R001C00": 250000, "V300R001C01": 250000,
              "V300R001C20": 250000, "V300R001C21": 250000,
              "V300R001C30": 1000000, "V300R002C00": 1000000,
              "V300R002C10": 1000000, "V300R002C20": 1000000},
        256: {"V300R001C01": 500000, "V300R001C20": 500000,
              "V300R001C21": 500000,
              "V300R001C30": 1000000, "V300R002C00": 1000000,
              "V300R002C10": 1000000, "V300R002C20": 1000000}
    },
    "Dorado6000 V3": {
        256: {"V300R001C00": 500000, "V300R001C01": 500000,
              "V300R001C20": 500000, "V300R001C21": 500000,
              "V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000},
        512: {"V300R001C00": 1000000, "V300R001C01": 1000000,
              "V300R001C20": 1000000, "V300R001C21": 1000000,
              "V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000},
        1024: {"V300R001C00": 1000000, "V300R001C01": 1000000,
               "V300R001C20": 1000000, "V300R001C21": 1000000,
               "V300R001C30": 2000000, "V300R002C00": 2000000,
               "V300R002C10": 2000000, "V300R002C20": 2000000}
    },
    "Dorado18000 V3": {
        256: {"V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000},
        512: {"V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000},
        1024: {"V300R001C30": 2000000, "V300R002C00": 2000000,
               "V300R002C10": 2000000, "V300R002C20": 2000000}
    }
}

# 融合高端无SVP组网
MGMT_PORT_CONFIG_NO_SVP = {
    # 2引擎场景：
    "2": {
        "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
        "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",

        "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
        "CTE1.SMM1.MGMT2": "DSW0.MGMT.0",
        "DSW0.MGMT.1": "DSW1.MGMT.0",
    },
    # 3引擎场景：
    "3": {
        "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
        "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",
        "CTE1.SMM0.MGMT1": "CTE2.SMM0.MGMT2",

        "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
        "CTE1.SMM1.MGMT2": "CTE2.SMM1.MGMT1",
        "CTE2.SMM1.MGMT2": "DSW0.MGMT.0",
        "DSW0.MGMT.1": "DSW1.MGMT.0",
    },
    # 4引擎场景：
    "4": {
        "CTE0.SMM0.MGMT1": "CTE1.SMM0.MGMT2",
        "CTE0.SMM0.MGMT2": "DSW1.MGMT.1",
        "CTE1.SMM0.MGMT1": "CTE2.SMM0.MGMT2",
        "CTE2.SMM0.MGMT1": "CTE3.SMM0.MGMT2",

        "CTE0.SMM1.MGMT2": "CTE1.SMM1.MGMT1",
        "CTE1.SMM1.MGMT2": "CTE2.SMM1.MGMT1",
        "CTE2.SMM1.MGMT2": "CTE3.SMM1.MGMT1",
        "CTE3.SMM1.MGMT2": "DSW0.MGMT.0",
        "DSW0.MGMT.1": "DSW1.MGMT.0",
    }
}

# 融合高端无SVP组网下，可以连接用户管理网络的端口
MGMT_PORT_CONFIG_NO_SVP_HOST = {
    # 1引擎场景
    "1": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0"],
    # 2引擎场景
    "2": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0",
          "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0"],
    # 3引擎场景
    "3": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0",
          "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0",
          "CTE2.SMM0.MGMT0", "CTE2.SMM1.MGMT0"],
    # 4引擎场景
    "4": ["CTE0.SMM0.MGMT0", "CTE0.SMM1.MGMT0",
          "CTE1.SMM0.MGMT0", "CTE1.SMM1.MGMT0",
          "CTE2.SMM0.MGMT0", "CTE2.SMM1.MGMT0",
          "CTE3.SMM0.MGMT0", "CTE3.SMM1.MGMT0"],
}

# 控制器逻辑引擎映射，用于计算逻辑引擎号
NODE_MAP = {
    "A": 0,
    "B": 0,
    "C": 1,
    "D": 1,
}


# 告警级别配置
class AlarmLevel:
    # 警告
    warning = 3
    # 重要
    major = 5
    # 紧急
    critical = 6


# 备件检查端口一致性进度总时间
PORTS_TOTAL_TIME_SECS = 210
# 更换后端口轮询时间
LOOP_CHECK_PORTS_TIME_SECS = 180
# 检查业务压力的总进度时间
CHECK_PRESSURE_PROCESS_TIME_SECS = 420

# 交换机CE6881配置命令
SWITCH_CONFIG_CE6881 = CE6881

# DoradoNAS起始版本号
DORADO_NAS = "6.1.RC3"

class VersionManager:
    """版本配置管理"""
    V5_SWITCH_AND_CP = "V500R007C70SPC200"  # V5 kunpeng开始支持交换机及C+的版本
    V6_SWITCH_AND_CP = "6.1.RC3"  # DoradoV6开始支持交换机及C+的版本
    V5_DIRECT = "V500R007C60SPC300"
    V5_SWITCH = "V500R007C70SPC200"
    V5_MIDDLE_SWITCH = "V500R007C71"
    V6_DIRECT = "6.0.0"
    V6_SWITCH = "6.1.RC3"
    V6_SUPPORT_16_CTRL = "6.1.2RC1"
    # V5不支持扩控版本，评估用
    V5_NOT_SUP_CTRL_EXP = ["V500R007C60 Kunpeng", "V500R007C60SPC100 Kunpeng",
                           "V500R007C60SPC200 Kunpeng"]


def compare_dorado_version(ori_ver, comp_ver):
    """
    对比两个DORADO版本大小，如果ori_ver>=comp_ver，第二个值返回True，反之为False，
    若不存在，第一个值返回False

    @params: ori_ver 原设备版本
    @params: comp_ver 比对版本
    """
    # 检查输入合法性
    if "" in (ori_ver, comp_ver):
        return False, False

    res = Products.compareVersion(ori_ver, comp_ver)
    if res >= 0:
        return True, True
    elif res == -1:
        return True, False
    else:
        return False, False
