# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-. All rights reserved.
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil


def get_info_by_cli(cli, lang):
    """获取接口模块信息
    通过cli的show interface_module命令

    :param cli: cli连接
    :param lang: 语言
    :return:
        成功失败标志
        接口模块信息列表
        cli原始返回信息
        错误消息
    """
    # 执行命令获取返回结果
    cmd = "show interface_module"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return False, None, cli_ret, err_msg

    # 整理返回结果
    interface_module_info_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    return True, interface_module_info_list, cli_ret, err_msg


def get_health_status_and_running_status_by_id(context, param_id):
    """获取接口模块的健康状态和运行状态

    :param context: python上下文
    :param param_id: 接口模块ID 例如 CTE0.A.IOM0
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)

    # 获取接口模块信息
    flag, interface_modules, cli_ret, err_msg = get_info_by_cli(cli, lang)
    if not flag:
        return False, "", "", err_msg

    health_status = ""
    running_status = ""
    for interface_module in interface_modules:
        interface_module_id = interface_module.get("ID")
        if interface_module_id == param_id:
            health_status = interface_module.get("Health Status", "")
            running_status = interface_module.get("Running Status", "")
            break

    return health_status, running_status
