# -*- coding: UTF-8 -*-
import json


def getJsonStr(obj):
    """
    将字典或集合类型数据结构转成json字符串
    :param obj: 字典或集合类型数据结构
    :return: 转换后的json数据
    """
    if type(obj) == dict:
        return dict2JsonStr(obj)

    if type(obj) == list:
        strObj = "["
        metFirst = False
        for index in range(0, len(obj)):
            strDict = dict2JsonStr(obj[index])
            if metFirst is True:
                strObj = strObj + ', ' + strDict
            else:
                strObj = strObj + strDict
                metFirst = True
        strObj = strObj + ']'
        return strObj

    return ""


def dict2JsonStr(obj):
    """
    将字典类型数据结构转成json字符串
    :param obj: 字典类型数据结构
    :return:  json字符串
    """
    return json.dumps(obj)


def dict2JsonStrByDumps(obj):
    """
    将字典类型数据结构转成json字符串
    :param obj: 字典类型数据结构
    :return: 字典转为json数据
    """
    return json.dumps(obj)


def jsonStr2Dict(strJson):
    """
    将json字符串转成字典数据结构
    :param strJson: json字符串
    :return: json转换后的字典
    """
    return json.loads(strJson)


def dictList2JsonArray(portsInfoList):
    """
    将字典的集合转换为json数组
    :param portsInfoList:端口的字典列表集合
    :return:端口信息对应的json数组
    """
    jsonArray = []
    for portsInfoDict in portsInfoList:
        jsonArray.append(
            "{%s}"
            % ",".join(['"%s":"%s"' % (key, portsInfoDict.get(key))
                        for key in portsInfoDict.keys()]))
    return "[%s]" % ",".join(jsonArray)


def jsonArray2DictList(jsonArray):
    """
    将json数组转换为字典的集合
    :param jsonArray:json数组
    :return:json数组对应的字典的集合
    """
    if jsonArray is None or len(jsonArray) <= 2:
        return None
    jsonArray = jsonArray[1:-1]
    resultDictList = []
    for items in jsonArray.split("},{"):
        resultDict = {}
        for item in items.split("\",\""):
            kv = item.replace("{", "").replace("}", "").\
                replace("\"", "").split(":")
            if len(kv) != 2:
                return resultDictList
            resultDict[kv[0]] = kv[1]
        if len(resultDict.keys()) > 0:
            resultDictList.append(resultDict.copy())

    return resultDictList


def jsonStr2DictNew(strJson):
    """
    将json字符串转成字典数据结构
    :param strJson: json字符串
    :return: json转换后的字典
    """
    dict = json.loads(strJson)
    return dict


def dumpsObj(val):
    """递归算法获取python对象的json字符串

    Note: 未充分测试,慎用。

    :param val: 待转换的数据
    :return:转换后的数据
    """
    if isinstance(val, str) and val.startswith('\"'):
        return val
    elif isinstance(val, str):
        return '"' + val + '"'
    elif isinstance(val, unicode):
        return '"' + val + '"'
    elif isinstance(val, int):
        return '"' + str(val) + '"'
    elif isinstance(val, list):
        return dumpsList(val)
    elif isinstance(val, dict):
        return dumpsDict(val)

    return '"' + str(val) + '"'


def dumpsDict(obj):
    """将字典类型数据结构转成json字符串

    :param obj:字典类型数据结构
    :return:字典转换后的json数据
    """
    strLeftDictMark = "{"
    strRightDictMark = "}"
    jsonStr = ""

    metFirst = False
    for (key, value) in obj.items():
        if metFirst:
            jsonStr = jsonStr + ', ' + dumpsObj(key) + ': ' + dumpsObj(value)
        else:
            jsonStr = strLeftDictMark + dumpsObj(key) + ': ' + dumpsObj(value)
            metFirst = True

    jsonStr = jsonStr + strRightDictMark

    return jsonStr


def dumpsList(dictList):
    """将列表类型数据结构转成json字符串

    :param dictList:列表数据
    :return:转换后的json字符串
    """
    listLeftMark = '['
    listRightMark = ']'
    jsonStr = listLeftMark
    dictJsonLines = []
    for item in dictList:
        itemJson = dumpsObj(item)
        dictJsonLines.append(itemJson)

    jsonRet = jsonStr + ', '.join(dictJsonLines) + listRightMark
    return jsonRet
