# -*- coding: UTF-8 -*-
from cbb.frame.dsl.operator.exec_cli import (
    ExecCliDsl,
    ExecDeveloperDsl,
    ExecDiagnoseDsl,
    ExecMiniSystemDsl
)
from cbb.frame.dsl.operator.exec_on_all import ExecOnAllDsl
from cbb.frame.dsl.operator.parser_echo import (
    ParserDsl,
    GetKeyDsl,
    RegexDsl,
    LogicDsl,
    FilterDsl,
    SplitlinesDsl,
    EchoDsl,
    GetIndexDsl,
    SplitDsl
)
from cbb.frame.dsl.operator.exec_log import ExecLogDsl
from cbb.frame.dsl.operator.exec_rest import ExecRestDsl
from cbb.frame.dsl.operator.exec_on_all_of_mini_sys import ExecOnAllOfMiniSysDsl


def get_data_source_operators(context):
    """
    dsl支持的用作数据源操作符
    :param context: 上下文
    :return: dsl表达式
    """
    return ExecCliDsl(context).get() \
        | ExecDiagnoseDsl(context).get() \
        | ExecMiniSystemDsl(context).get() \
        | ExecDeveloperDsl(context).get() \
        | EchoDsl(context).get() \
        | ExecLogDsl(context).get() \
        | ExecRestDsl(context).get() \
        | ExecOnAllDsl(context).get() \
        | ExecOnAllOfMiniSysDsl(context).get()


def get_parser_operators(context):
    """
    dsl支持的用作解析的操作符
    :param context: 上下文
    :return: dsl表达式
    """
    return ParserDsl(context).get() \
        | GetKeyDsl(context).get()\
        | RegexDsl(context).get() \
        | LogicDsl(context).get() \
        | FilterDsl(context).get() \
        | SplitlinesDsl(context).get() \
        | SplitDsl(context).get() \
        | GetIndexDsl(context).get()
