# -*- coding: UTF-8 -*-

from cbb.frame.util import baseUtil
from cbb.frame.util import contextUtil


def getItemName(checkItemName, lang, resource):
    itemName = resource.getString(checkItemName)
    if itemName == None or itemName == "" or itemName == '--':
        itemName = baseUtil.getMsg(lang, checkItemName)
    if itemName == None or itemName == "" or itemName == '--':
        itemName = checkItemName
    return itemName


def getPassMsg(checkItemName, msgType, lang, resource):
    suggession = resource.getString(checkItemName + "." + msgType)
    if suggession == None or suggession == "" or suggession == '--':
        suggession = baseUtil.getMsg(lang, checkItemName + "." + msgType)
    if suggession == None or suggession == "" or suggession == '--':
        suggession = baseUtil.getMsg(lang, "precheck.common." + msgType)
    return suggession


"""
   判断是否当前检查项通过了
"""


def isAllItemsPassed(dataDict, UI_CHECK_UPDATE_MSG, checkType):
    resource = dataDict.get("resource")

    ##判断当前检查项是否是都检查通过了
    checkItems = UI_CHECK_UPDATE_MSG.get("checkitems")
    currentItem = [item for item in checkItems if item['name'] == checkItems[-1]['name']]
    for item in currentItem:
        ## 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        itemState = item.get("status")
        if 4 == itemState and checkType == "precheck":
            return (False, resource.getString("upgrade.precheck.notpassed"))
        elif 4 == itemState and checkType == "postcheck":
            return (False, resource.getString("upgrade.postcheck.notpassed"))

    return (True, "")


""" 
    更新忽略后的界面消息
"""


def updateMsgAferIgnore(dataDict, checkItem):
    uiObserver = dataDict.get("uiObserver")
    resource = dataDict.get("resource")
    lang = contextUtil.getLang(dataDict)
    dev = dataDict.get("dev")
    UI_PRECHCK_UPDATE_MSG = dataDict['UI_PRECHCK_UPDATE_MSG']
    itemMsgList = UI_PRECHCK_UPDATE_MSG.get("checkitems")

    itemName = getItemName(checkItem, lang, resource)

    passMsg = getPassMsg(checkItem, "pass", lang, resource)

    for itemMsg in itemMsgList:
        if itemMsg["name"] == itemName and itemMsg["status"] == 4:
            itemMsg["status"] = 5  # 检查已忽略
            itemMsg["suggession"] = passMsg  # 检查通过

    uiObserver.postMsg(dev, UI_PRECHCK_UPDATE_MSG)
    return


""" 
    更新忽略后的界面消息
"""


def updateMsgAferRetry(dataDict, checkItem):
    uiObserver = dataDict.get("uiObserver")
    resource = dataDict.get("resource")
    lang = contextUtil.getLang(dataDict)
    dev = dataDict.get("dev")

    checkType = dataDict['checkType']
    if checkType == "PRECHECK":
        UI_ECHCK_UPDATE_MSG = dataDict['UI_PRECHCK_UPDATE_MSG']
    else:
        UI_ECHCK_UPDATE_MSG = dataDict['UI_POSTCHCK_UPDATE_MSG']
    itemMsgList = UI_ECHCK_UPDATE_MSG.get("checkitems")
    itemName = getItemName(checkItem, lang, resource)
    newItemMsgList = []
    for itemMsg in itemMsgList:
        if itemMsg["name"] != itemName:
            newItemMsgList.append(itemMsg)

    UI_ECHCK_UPDATE_MSG["checkitems"] = newItemMsgList
    uiObserver.postMsg(dev, UI_ECHCK_UPDATE_MSG)
    return


"""
   判断是否可忽略检查项都通过,未通过的返回1，即暂停由用户选择操作，
   只对当前检查项进行处理
"""


def isIngnoreItemPassed(dataDict, UI_CHECK_UPDATE_MSG, checkType, checkItemName=''):
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    upgradeModel = str(dev.getUpgradeSetInfo().getModel())  # 获取升级执行模式是专家模式或普通

    ##判断当前检查项是否是都检查通过
    isPreCheckPause = True
    checkItems = UI_CHECK_UPDATE_MSG.get("checkitems")
    currentItem = [item for item in checkItems if item['name'] == checkItems[-1]['name']]
    for item in currentItem:
        itemState = item.get("status")
        if 4 == itemState and "precheck" == checkType:
            return (False, resource.getString("upgrade.precheck.notpassed"), 6)

    return (True, "", 0)


def updateItemProgressNoDelay(dataDict, checkItem, progressEnd, suggession=None):
    return updateItemProgress(dataDict, checkItem, progressEnd, suggession, delay=False)


def updateItemProgress(dataDict, checkItem, progressEnd, suggession=None, delay=True):
    uiObserver = dataDict.get("uiObserver")
    resource = dataDict.get("resource")
    dev = dataDict.get("dev")
    UI_POSTCHCK_UPDATE_MSG = dataDict['UI_POSTCHCK_UPDATE_MSG']
    itemMsgList = UI_POSTCHCK_UPDATE_MSG.get("checkitems")
    itemName = resource.getString(checkItem)

    progressStart = 0
    newItemMsgList = []
    for itemMsg in itemMsgList:
        if itemMsg["name"] != itemName:
            newItemMsgList.append(itemMsg)
        else:
            progressStart = itemMsg.get("progress", 0)

    if progressEnd <= progressStart:
        return

    if not suggession or suggession == "":
        suggession = resource.getString("checkitem.step.checking")
    else:
        suggession = resource.getString(suggession)
    itemMsg = {
        "id": 1,
        # 检查项名称，类型String
        "name": resource.getString(checkItem),
        # 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        "status": 1,
        "ctrl": "ALL",
        # 修复建议
        "suggession": suggession,
        "progress": -1,
    }
    newItemMsgList.append(itemMsg)
    UI_POSTCHCK_UPDATE_MSG["checkitems"] = newItemMsgList

    if delay:
        for progressNum in range(progressStart, progressEnd + 1):
            baseUtil.safeSleep(0.2)
            itemMsg['progress'] = progressNum
            itemMsgTempList = UI_POSTCHCK_UPDATE_MSG.get("checkitems")
            for item in itemMsgTempList:
                if item["name"] == itemName:
                    item['progress'] = progressNum
                    break
            uiObserver.postMsg(dev, UI_POSTCHCK_UPDATE_MSG)
    else:
        itemMsg['progress'] = progressEnd
        itemMsgTempList = UI_POSTCHCK_UPDATE_MSG.get("checkitems")
        for item in itemMsgTempList:
            if item["name"] == itemName:
                item['progress'] = progressEnd
                break
        uiObserver.postMsg(dev, UI_POSTCHCK_UPDATE_MSG)
    return
