#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh

function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start checking components health status."
    for comp in ${components[@]} ; do
        micro_service=`echo ${comp} | awk -F ':' '{print $1}'`
        component_name=`echo ${comp} | awk -F ':' '{print $2}'`
        component_dir=`ls ${MICRO_PATH} | grep -v tar.gz | grep ^${component_name}_[0-9].* | sort -r | head -1`
        if [ -z "${component_dir}" ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] ${component_name} component is not installed."
            continue
        fi
        execute_oamx_script ${micro_service} ${component_name} ${PRECHECK}
        ret=$?
        if [ ${ret} -ne 0 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] ${component_name} component health status is abnormal."
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] The software health status is abnormal, the check fails."
            return $ret
        fi
    done
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] The software health status is normal, the check is successful."
    return 0
}

main
ret=$?
if [ ${ret} -eq 0 ]; then
    print_result "normal     status"
else
    print_result "abnormal   status"
fi
exit ${ret}
