#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/rollback_common.sh
BASE_PATH="/opt/fusionstorage/deploymanager/compute_upgrade"
UPGRADE_STATUS_PATH="${BASE_PATH}/compute_upgrade.ini"
ROLLBACK_STATUS_PATH="${BASE_PATH}/compute_rollback.ini"
ROLLBACK_STATUS_TMP_PATH="${BASE_PATH}/compute_rollback_temp.ini"
fsa_cgroup_cfg="/etc/fsa_cgroup_path"
FLOAT_IP=""


function conf_cgroup()
{
    log $SCRIPTNAME $FUNCNAME "[INFO] begin to set cgroup"
    if [ -f /usr/bin/FusionStorage-AgentControl ];then
        log $SCRIPTNAME $FUNCNAME "[INFO] hcs or nfv scenes set cgroup"
        hcs_scenes
    else
        log $SCRIPTNAME $FUNCNAME "[INFO] other scenes set cgroup"
        cube_scenes
    fi
 }

 function cube_scenes() {
     if [ -f "${fsa_cgroup_cfg}" ];then
        fsa_cgroup_cpu_path=$(cat ${fsa_cgroup_cfg} | grep "fsa_cpu_path" | awk -F '=' '{print $2}')
        fsa_cgroup_mem_path=$(cat ${fsa_cgroup_cfg} | grep "fsa_mem_path" | awk -F '=' '{print $2}')
        if [ -n "${fsa_cgroup_cpu_path}" ];then
            #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
            echo $$ > ${fsa_cgroup_cpu_path}
        fi
        if [ -n "${fsa_cgroup_mem_path}" ];then
            #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
            echo $$ > ${fsa_cgroup_mem_path}
        fi
        log $SCRIPTNAME $FUNCNAME "fusion cube cgroup is create and set"
    elif [ -d /sys/fs/cgroup/cpuset/fusionstorage/dsware ];then
        echo $$ > /sys/fs/cgroup/cpuset/fusionstorage/dsware/tasks
        if [ -d /sys/fs/cgroup/memory/fusionstorage/dsware ];then
            echo $$ > /sys/fs/cgroup/memory/fusionstorage/dsware/tasks
        fi
        log $SCRIPTNAME $FUNCNAME "new cgroup is create and set"
    elif [ -d /cgroup/cpuset/dsware ]
    then
        #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
        echo $$ > /cgroup/cpuset/dsware/tasks
        if [ -d /cgroup/memory/dsware/ ];then
            echo $$ > /cgroup/memory/dsware/tasks
        fi
        log $SCRIPTNAME $FUNCNAME "old cgroup is create and set"
    fi
 }

 function hcs_scenes() {
     pid_agent=`ps -ef|grep FusionStorage-AgentControl|grep -v grep|head -n 1 | awk '{print $2}'`
     if [ -n ${pid_agent} ];then
        cpuset=`cat /proc/${pid_agent}/cgroup |grep cpuset|awk -F : '{print $NF}'`
        echo $$ > /sys/fs/cgroup/cpuset${cpuset}/tasks
        memset=`cat /proc/${pid_agent}/cgroup |grep memory|awk -F : '{print $NF}'`
        echo $$ > /sys/fs/cgroup/memory${memset}/tasks
     fi
 }

function main()
{
    if [ -f "/etc/profile" ];then
        source /etc/profile
    fi
    touch_rollback_step_to_file  UPGRADE_STATUS status "running"
    #升级,升级中有升级前检查
    bash ${CURRENT_PATH}/rollback.sh
    if [[ $? -ne 0 ]];then
        set_rollback_failed
        log $SCRIPTNAME $FUNCNAME "[ERROR]compute upgrade failed."
        return 1
    fi
	cd /opt/fusionstorage/deploymanager/ && rm -rf compute_backup
	cd /opt/fusionstorage && rm -f deploy.ini
    return 0

}

function touch_step_ini()
{
	if [ ! -f ${ROLLBACK_STATUS_PATH} ];then
		\cp -f ${ROLLBACK_STATUS_TMP_PATH}  ${ROLLBACK_STATUS_PATH}
		init_step
		rm -f ${SCENES_INFO}
	fi

}

function init_step() {
    log $SCRIPTNAME $FUNCNAME "[INFO] begin to init_step"
    if [ -f ${UPGRADE_STATUS_PATH} ];then
         for comp in ${rollback_components[@]} ; do
            component_name=`echo ${comp} | awk -F ':' '{print $2}'`
            log $SCRIPTNAME $FUNCNAME "[INFO] begin to get_upgrade_step_from_file ${component_name}"
            for action in ${upgrade_actions[@]}; do
                if [ "${action}x" == "readyx" ];then
                    continue
                fi
                log $SCRIPTNAME $FUNCNAME "[INFO] begin to get_upgrade_step_from_file ${component_name} ${action}"
                result=`get_upgrade_step_from_file ${component_name} ${component_name}_${action}`
                echo
                if [ "${result}"x == "${ACTION_INIT}"x ]; then
                    do_touch ${component_name} ${action}
                fi
            done
        done
    fi
}

#upgrade_failed_rollback_actions=("offline:online" "stop:start" "upgrade:rollback" "start:stop" "check_status:stop" "online:offline" "all:ready")
function do_touch() {
    log $SCRIPTNAME $FUNCNAME "[INFO] begin to do_touch $1 $2"
    COMPONENT_NAME=$1
    ACTION=$2
    case "${ACTION}" in
    offline)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_online ${ACTION_SUCCESS}
        ;;
    stop)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_start ${ACTION_SUCCESS}
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_check_status ${ACTION_SUCCESS}
        ;;
    upgrade)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_rollback ${ACTION_SUCCESS}
        ;;
    check_status)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_stop ${ACTION_SUCCESS}
        ;;
    start)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_stop ${ACTION_SUCCESS}
        ;;
    online)
        touch_rollback_step_to_file ${COMPONENT_NAME} ${COMPONENT_NAME}_offline ${ACTION_SUCCESS}
        ;;
    *)
        ;;
esac

}

{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Get ${LOCKFILE} file lock."
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
	touch_step_ini
	conf_cgroup
    main $@
    ret=$?
    flock -u 3
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Unlock ${LOCKFILE} file lock."
    exit $ret

} 3<>${LOCKFILE}