#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh
BASE_PATH="/opt/fusionstorage/deploymanager/compute_upgrade"
UPGRADE_STATUS_PATH="${BASE_PATH}/compute_upgrade.ini"
UPGRADE_STATUS_TMP_PATH="${BASE_PATH}/compute_upgrade_temp.ini"
fsa_cgroup_cfg="/etc/fsa_cgroup_path"
FLOAT_IP=""
ARCH=$(uname -m)
backup_dir="/opt/fusionstorage/deploymanager/compute_backup/${ARCH}"

echo "Password:"
read -rs TOKEN

function check_params()
{
   local status_flag=$1
   local float_ip_param=$2
   local float_ip=`cat ${CLOUDA_CONFIG} | grep -w cloudm_float_ip | awk -F '=' '{print $2}'`
   if [ "X${float_ip_param}" != "X${float_ip}" ];then
        log $SCRIPTNAME $FUNCNAME "[ERROR] ${float_ip_param} is not right, ${float_ip_param} ${float_ip}"
        set_failed
        return 1
   fi
   if [[ "X${status_flag}" == "X" ]];then
        log $SCRIPTNAME $FUNCNAME "[ERROR] status_flag is empty"
        set_failed
        return 1
   fi
   local_status_file=`get_upgrade_step_from_file UPGRADE_FLAG upgrade_time_flag`
   if [[ "X${local_status_file}" == "X" ]];then
        log $SCRIPTNAME $FUNCNAME "[ERROR]compute upgrade status file is empty"
        set_failed
        return 1
   fi
   if [[ "X${local_status_file}" == "Xinitial" ]];then
        touch_upgrade_step_to_file UPGRADE_FLAG "upgrade_time_flag" ${status_flag}
        return 0
   elif [[ "X${local_status_file}" != "X${status_flag}" ]];then
        log $SCRIPTNAME $FUNCNAME "[ERROR]compute upgrade status ${status_flag} is not right"
   fi
   return 0
}

function conf_cgroup()
{
    log $SCRIPTNAME $FUNCNAME "[INFO] begin to set cgroup"
    if [ -f /usr/bin/FusionStorage-AgentControl ];then
        log $SCRIPTNAME $FUNCNAME "[INFO] hcs or nfv scenes set cgroup"
        hcs_scenes
    else
        log $SCRIPTNAME $FUNCNAME "[INFO] other scenes set cgroup"
        cube_scenes
    fi
 }

 function cube_scenes() {
     if [ -f "${fsa_cgroup_cfg}" ];then
        fsa_cgroup_cpu_path=$(cat ${fsa_cgroup_cfg} | grep "fsa_cpu_path" | awk -F '=' '{print $2}')
        fsa_cgroup_mem_path=$(cat ${fsa_cgroup_cfg} | grep "fsa_mem_path" | awk -F '=' '{print $2}')
        if [ -n "${fsa_cgroup_cpu_path}" ];then
            #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
            echo $$ > ${fsa_cgroup_cpu_path}
        fi
        if [ -n "${fsa_cgroup_mem_path}" ];then
            #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
            echo $$ > ${fsa_cgroup_mem_path}
        fi
        log $SCRIPTNAME $FUNCNAME "fusion cube cgroup is create and set"
    elif [ -d /sys/fs/cgroup/cpuset/fusionstorage/dsware ];then
        echo $$ > /sys/fs/cgroup/cpuset/fusionstorage/dsware/tasks
        if [ -d /sys/fs/cgroup/memory/fusionstorage/dsware ];then
            echo $$ > /sys/fs/cgroup/memory/fusionstorage/dsware/tasks
        fi
        log $SCRIPTNAME $FUNCNAME "new cgroup is create and set"
    elif [ -d /cgroup/cpuset/dsware ]
    then
        #$$为本进程PID，它所有子进程或由它子进程拉起的进程都能继承这个分组
        echo $$ > /cgroup/cpuset/dsware/tasks
        if [ -d /cgroup/memory/dsware/ ];then
            echo $$ > /cgroup/memory/dsware/tasks
        fi
        log $SCRIPTNAME $FUNCNAME "old cgroup is create and set"
    fi
 }

 function hcs_scenes() {
     pid_agent=`ps -ef|grep FusionStorage-AgentControl|grep -v grep|head -n 1 | awk '{print $2}'`
     if [ -n ${pid_agent} ];then
        cpuset=`cat /proc/${pid_agent}/cgroup |grep cpuset|awk -F : '{print $NF}'`
        echo $$ > /sys/fs/cgroup/cpuset${cpuset}/tasks
        memset=`cat /proc/${pid_agent}/cgroup |grep memory|awk -F : '{print $NF}'`
        echo $$ > /sys/fs/cgroup/memory${memset}/tasks
     fi
 }

function main()
{
    if [ -f "/etc/profile" ];then
        source /etc/profile
    fi
    touch_upgrade_step_to_file  UPGRADE_STATUS status "running"
	if [ -d "/opt/fusionstorage/deploymanager/compute_backup" ];then
	    rm -rf /opt/fusionstorage/deploymanager/compute_backup/upgrade_*
	    touch ${status_running}
		chmod 777 ${status_running}
	fi
    #检查参数 $1 flag $2 float_ip
    check_params $1 $2
    if [[ $? -ne 0 ]];then
        log $SCRIPTNAME $FUNCNAME "[ERROR]compute upgrade check_params failed."
        return 1
    fi
    #升级,升级中有升级前检查
    bash ${CURRENT_PATH}/upgrade.sh <<EOF
${TOKEN}
EOF
    if [[ $? -ne 0 ]];then
        set_failed
        log $SCRIPTNAME $FUNCNAME "[ERROR]compute upgrade failed."
        return 1
    fi
    return 0

}

function touch_step_ini()
{
	if [ ! -f ${UPGRADE_STATUS_PATH} ];then
		\cp -f ${UPGRADE_STATUS_TMP_PATH}  ${UPGRADE_STATUS_PATH}
	fi
    if [ -d ${backup_dir} ] && [ -f ${status_success} ];then
        rm -rf ${backup_dir}
    fi
}

{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Get ${LOCKFILE} file lock."
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
    log $SCRIPTNAME $FUNCNAME "params: $1"
	touch_step_ini
	conf_cgroup
    main $@
    ret=$?
    flock -u 3
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Unlock ${LOCKFILE} file lock."
    exit $ret

} 3<>${LOCKFILE}