#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
readonly PKG_PATH=$(realpath "${CURRENT_PATH}/../")
source ${CURRENT_PATH}/rollback_common.sh
UPGRADE_TOKEN=""



function check_role()
{
    local role=`cat ${NETWORK_CONFIG}|grep -e ^role= |awk -F = '{print $2}'`
    if [ $? -ne 0 ];then
        return 1
    fi
    if [ ${role}"X" == "X" ];then
        if [ -f /opt/fusionstorage/deploymanager/version ];then
            return 1
        elif [ -d "/opt/dsware/eds/eds" ];then
            return 1
        else
            return 0
        fi
    elif [[ "${role}" =~ .*management.* ]];then
        return 1
    elif [[ "${role}" =~ .*storage.* ]];then
        return 1
    else
        return 0
    fi
}

function check_micro()
{
    if [ ! -f ${CURRENT_PATH}/component_old_version_for_rollback.ini ];then
        \cp -f ${CURRENT_PATH}/component_old_version_for_rollback_temp.ini ${CURRENT_PATH}/component_old_version_for_rollback.ini
        echo ''>${CURRENT_PATH}/component_old_version_for_rollback.ini
        ls -t "${MICRO_PATH}" | grep -v grep |grep -v "tar.gz" >${CURRENT_PATH}/component_old_version_for_rollback.ini
        if [[ $? -ne 0 ]];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check_micro error."
            return 1
        fi
        for comp in ${rollback_components[@]} ; do
            micro_service=`echo ${comp} | awk -F ':' '{print $1}'`
            component_name=`echo ${comp} | awk -F ':' '{print $2}'`
            count=`cat ${CURRENT_PATH}/component_old_version_for_rollback.ini | grep -v grep |grep -v "*.tar.gz" |  grep "${component_name}_"| wc -l`
            if [[ ${count} -ne 1 ]];then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check ${component_name} count error."
				if [ -d /opt/fusionstorage/deploymanager/compute_backup/${ARCH} ];then
				    old_package=$(ls /opt/fusionstorage/deploymanager/compute_backup/${ARCH} |grep -v grep |grep "${component_name}_")
					if [ ! -z ${old_package} ];then
					    old_version=$(echo ${old_package} | awk -F '.tar.gz' '{print $1}')
						new_version=$(cat ${CURRENT_PATH}/component_old_version_for_rollback.ini | grep -v grep |grep -v "*.tar.gz" | grep "${component_name}_"| grep -v ${old_version})
						if [ ! -z ${new_version} ];then
						    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Delete the directory that fails to be upgraded. dir=${MICRO_PATH}/${new_version}"
						    rm -rf ${MICRO_PATH}/${new_version}
						    rm -rf ${MICRO_PATH}/${new_version}.tar.gz
						fi
					else
					    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check ${old_package} is empty."
					    return 1
					fi
				else
				    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] /opt/fusionstorage/deploymanager/compute_backup/${ARCH} the directory does not exist."
				    return 1
				fi
            fi
        done
    fi
    return 0
}


function pre_upgrade()
{
    check_role
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check role error."
        return 1
    fi
    config_mark_info ${TASK_TYPE_ROLLBACK}
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] config_mark_info error!"
        return 1
    fi
    check_micro
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check micro count error."
        return 1
    fi
    return 0
}

function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start the upgrade rollback."
    task_isolation ${TASK_TYPE_ROLLBACK}
    if [[ $? -ne 0 ]];then
         log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Cannot perform ${TASK_TYPE_UPGRADE} operation!"
         set_failed
         return 1
    fi
    result=`get_rollback_step_from_file UPGRADE_STATUS prepare`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        pre_upgrade
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] pre_upgrade error!"
             set_failed
             return 1
        fi
        touch_rollback_step_to_file  UPGRADE_STATUS prepare ${ACTION_SUCCESS}
    fi

    result=`get_rollback_step_from_file UPGRADE_STATUS rollback`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        execute_upgrade_rollback_action
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] upgrade ${component_name} failed!"
             set_failed
             return 1
        fi
        touch_rollback_step_to_file  UPGRADE_STATUS rollback ${ACTION_SUCCESS}
    fi

    result=`get_rollback_step_from_file UPGRADE_STATUS postcheck`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        postcheck
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Post check failed!"
             set_failed
             return 1
        fi
        touch_rollback_step_to_file  UPGRADE_STATUS postcheck ${ACTION_SUCCESS}
     fi
    result=`get_rollback_step_from_file UPGRADE_STATUS notify_complete`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        notify_complete
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Notify finished failed!"
             set_failed
             return 1
        fi
        touch_rollback_step_to_file  UPGRADE_STATUS notify_complete ${ACTION_SUCCESS}
    fi
	tar_packages=$(ls ${MICRO_PATH} |grep -v grep |grep ".tar.gz")
	if [ ! -z "${tar_packages}" ]; then
	    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] residual packages exist and need to be deleted!packages=[${tar_packages}]"
	    ls ${MICRO_PATH} |grep -v grep |grep ".tar.gz" |while read line; do rm -rf ${MICRO_PATH}/$line; done;
	fi
    clear
    touch_rollback_step_to_file  UPGRADE_STATUS status "success"
}

log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start the upgrade."
main $@
if [ $? -eq 0 ]; then
    print_result "upgrade   success"
else
    print_result "upgrade    failed"
fi
