#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
source ${CURRENT_PATH}/common.sh

function confirm()
{
    echo "DANGER:You are about to uninstall product software from the node. This operation will clear the data stored on the system and make product software unavailable."
    echo "Suggestion: Before performing this operation, confirm that you want to clear data on the node and ensure that you have correctly selected the node."
    echo -n "Are you sure want to continue(yes/no)? "
    read "confirm"
    if [ "${confirm}"x == "no"x ]; then
        echo "input no, stop to uninstall!"
        return 1
    elif  [ "${confirm}"x == "yes"x ]; then
        echo "star to uninstall！"
        return 0
    fi
    echo "input error, stop to uninstall!"
    return 1
}

clear_components()
{
    for comp in ${components[@]} ; do
        component_name=`echo ${comp} | awk -F ':' '{print $2}'`
        clear_component ${component_name}
        ret=$?
        if [ ${ret} -ne 0 ]; then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Failed to uninstall ${component_name} component."
            return ${ret}
        fi
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Successfully uninstalled ${component_name} component."
    done
    return $?
}

clear_clouda()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Begin clear clouda."
    if [ -d ${MICRO_PATH}/clouda_1.0.0/action -a -f ${MICRO_PATH}/clouda_1.0.0/action/stop.sh ]; then
        bash ${MICRO_PATH}/clouda_1.0.0/action/stop.sh >> ${LOG_FILE} 2>&1
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Stop clouda error."
        fi
    fi
    if [ -d ${MICRO_PATH}/clouda_1.0.0/action -a -f ${MICRO_PATH}/clouda_1.0.0/action/uninstall.sh ]; then
        bash ${MICRO_PATH}/clouda_1.0.0/action/uninstall.sh >> ${LOG_FILE} 2>&1
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Uninstall clouda error."
        fi
    fi

    pid=`ps -ef | grep cloud_agent | grep -v grep | awk '{print $2}'`
    if [ ! -z $pid ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] cloud_agent process remain, need clear: kill -9 $pid."
        kill -9 ${pid}
    fi

    os_version
    if [ "${OS_VERSION}"x == "Ubuntu"x ]; then
        dpkg -l | grep clouda >> ${LOG_FILE} 2>&1
        if [ $? -eq 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] clouda rpm package already exists, try to remove it."
            dpkg -r clouda >> ${LOG_FILE} 2>&1
        fi
    else
        rpm -qa | grep clouda >> ${LOG_FILE} 2>&1
        if [ $? -eq 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] clouda rpm package already exists, try to remove it."
            rpm -e --nodeps --nopreun clouda >> ${LOG_FILE} 2>&1
        fi
    fi

    #删除/opt/fusionstorage/deploymanager/clouda目录下除了清理脚本以外的其他内容
    rm -rf `find /opt/fusionstorage/deploymanager/clouda/* ! -name 'clear_*.sh'`
    chattr -a ${MICRO_PATH}/clouda_1.0.0
    rm -rf ${MICRO_PATH}/clouda_1.0.0*

    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] clear clouda success."

    rm -rf /tmp/operation_result.txt
    rm -rf /tmp/clouda/install_clouda_success
    rm -rf /tmp/clouda/first_deploy_hcs

    if [ -f /usr/bin/FusionStorage-AgentControl ];then
        echo "cloud_agent=crontab:/opt/fusionstorage/deploymanager/clouda/bin/clouda.sh|/opt/fusionstorage/repository/deploymanager_pkg/micro/clouda_1.0.0/action/appctl.sh|no" > /usr/bin/FusionStorage-AgentControl_cps.cfg
    fi

    #clear share mem in clouda for kmc
    ipcrm -M 0x20170108 2>/dev/null
    ipcrm -S 0x20161227 2>/dev/null
    return 0
}

clear_mark()
{
    rm -f /home/.preinstall
    rm -rf /opt/fusionstorage/deploy.ini
    rm -f /opt/fusionstorage/.selfupgrade
}

main()
{
    confirm
    if [ $? -ne 0 ];then
        return 1
    fi
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start uninstallation."
    clear_components
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Failed to uninstall component." && return 1
    clear_mark
    clear_clouda
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Failed to uninstall clouda." && return 1
    return 0
}

{
    flock -n 3
    if [ $? -eq 1 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Another task is being executed, try it later."
        exit 1
    fi
    echo "$$" > ${LOCKFILE}

    main
    if [ $? -eq 0 ]; then
        print_result "uninstall success"
    else
        print_result "uninstall  failed"
    fi

    flock -u 3
} 3<>${LOCKFILE}
