#!/bin/bash

CURRENT_PATH=$(cd "$(dirname "$0")"; pwd)
SCRIPTNAME=$(basename $0)
readonly PKG_PATH=$(realpath "${CURRENT_PATH}/../")
source ${CURRENT_PATH}/common.sh

read -rs UPGRADE_TOKEN

function precheck()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start prechecking components status."
    for comp in ${components[@]} ; do
        micro_service=`echo ${comp} | awk -F ':' '{print $1}'`
        component_name=`echo ${comp} | awk -F ':' '{print $2}'`
        component_dir=`ls -t "${MICRO_PATH}" | grep -v grep |grep -v "*.tar.gz" |grep "${component_name}_" |head -n 1`
        if [ -z "${component_dir}" ]; then
            continue
        fi
        local count=0
        while true; do
            let count+=1
            execute_oamx_script ${micro_service} ${component_name} ${PRECHECK}
            ret=$?
            if [ ${ret} -eq 0 ]; then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] check ${component_name} ready for upgrade success."
                break
            fi
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check ${component_name} ready for upgrade failed."
            if [ ${count} -gt 12 ]; then
                log $SCRIPTNAME $FUNCNAME "[ERROR][Line:${LINENO}]check ${component_name} ready for upgrade failed."
                return 1
            fi
            sleep 5
            done
        done
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] precheck successful."
    return 0
}

function check_role()
{
    local role=`cat ${NETWORK_CONFIG}|grep -e ^role= |awk -F = '{print $2}'`
    if [ $? -ne 0 ];then
        return 1
    fi
    if [ ${role}"X" == "X" ];then
        if [ -f /opt/fusionstorage/deploymanager/version ];then
            return 1
        elif [ -d "/opt/dsware/eds/eds" ];then
            return 1
        else
            return 0
        fi
    elif [[ "${role}" =~ .*management.* ]];then
        return 1
    elif [[ "${role}" =~ .*storage.* ]];then
        return 1
    else
        return 0
    fi
}

function check_micro()
{
    if [ ! -f ${CURRENT_PATH}/component_old_version.ini ];then
        \cp -f ${CURRENT_PATH}/component_old_version_temp.ini ${CURRENT_PATH}/component_old_version.ini
        echo ''>${CURRENT_PATH}/component_old_version.ini
        ls -t "${MICRO_PATH}" | grep -v grep |grep -v "tar.gz" >${CURRENT_PATH}/component_old_version.ini
        if [[ $? -ne 0 ]];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check_micro error."
            return 1
        fi
        for comp in ${components[@]} ; do
            micro_service=`echo ${comp} | awk -F ':' '{print $1}'`
            component_name=`echo ${comp} | awk -F ':' '{print $2}'`
            count=`cat ${CURRENT_PATH}/component_old_version.ini | grep -v grep |grep -v "*.tar.gz" |  grep "${component_name}_"| wc -l`
            if [[ ${count} -ne 1 ]];then
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check ${component_name} count error."
                return 1
            fi
        done
    fi
    return 0
}


function pre_upgrade()
{
    check_role
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check role error."
        return 1
    fi
    config_mark_info ${TASK_TYPE_UPGRADE}
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] config_mark_info error!"
        return 1
    fi
    check_micro
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] check micro count error."
        return 1
    fi
#    需要从fsm下载包，此处下载软件包路径并保存
    generate_component_info ${UPGRADE_TOKEN}
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN ] No upgrade components!"
        clear
        return 2
    fi
    precheck
    if [ $? -ne 0 ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Pre check failed!"
        clear
        return 1
    fi
    return 0
}

function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start the upgrade."
    task_isolation ${TASK_TYPE_UPGRADE}
    if [[ $? -ne 0 ]];then
         log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Cannot perform ${TASK_TYPE_UPGRADE} operation!"
         set_failed
         return 1
    fi
    result=`get_upgrade_step_from_file UPGRADE_STATUS prepare`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        pre_upgrade
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] pre_upgrade error!"
             set_failed
             return 1
        fi
        touch_upgrade_step_to_file  UPGRADE_STATUS prepare ${ACTION_SUCCESS}
    fi

    #不单独升级clouda
    #upgrade_rollback_clouda ${TASK_TYPE_UPGRADE}
    #[[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] upgrade clouda failed!" && set_failed && return 1

    result=`get_upgrade_step_from_file UPGRADE_STATUS upgrade`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        execute_upgrade_rollback_action ${UPGRADE_TOKEN}
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] upgrade ${component_name} failed!"
             set_failed
             return 1
        fi
        touch_upgrade_step_to_file  UPGRADE_STATUS upgrade ${ACTION_SUCCESS}
    fi

    result=`get_upgrade_step_from_file UPGRADE_STATUS postcheck`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        postcheck
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Post check failed!"
             set_failed
             return 1
        fi
        touch_upgrade_step_to_file  UPGRADE_STATUS postcheck ${ACTION_SUCCESS}
     fi
    result=`get_upgrade_step_from_file UPGRADE_STATUS notify_complete`
    if [[ "X${result}" != "X${ACTION_SUCCESS}" ]];then
        notify_complete
        if [[ $? -ne 0 ]];then
             log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR ] Notify finished failed!"
             set_failed
             return 1
        fi
        touch_upgrade_step_to_file  UPGRADE_STATUS notify_complete ${ACTION_SUCCESS}
    fi
    clear
    touch_upgrade_step_to_file  UPGRADE_STATUS status "success"
	if [ -d "/opt/fusionstorage/deploymanager/compute_backup" ];then
	    rm -rf /opt/fusionstorage/deploymanager/compute_backup/upgrade_*
	    touch ${status_success}
		chmod 777 ${status_success}
	fi
}

log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO ] Start the upgrade."
main $@
if [ $? -eq 0 ]; then
    print_result "upgrade   success"
else
    print_result "upgrade    failed"
fi
