# -*- coding: UTF-8 -*-


class Timeout:
    # 默认重试次数
    DEFAULT_RETRY = 3
    # 默认重试间隔
    DEFAULT_INTERVAL = 10
    # 查询离线/上线节点超时时间 30分钟
    QUERY_TASK_TIMEOUT = 30*60
    # 离线/上线节点重试间隔
    INTERVAL_TIME = 15

    # 查询存储池状态重试间隔
    QUERY_POOL_STATUS_INTERVAL_TIME = 30
    # 查询存储池状态超时时间30分钟
    QUERY_POOL_STATUS_TIMEOUT = 30*60

    # 查询节点状态超时时间 20分钟
    QUERY_NODE_STATUS_TIMEOUT = 20 * 60


class Result:
    """ 脚本执行结果返回状态
    """
    PASS = "true"
    NOT_PASS = "false"


class PoolStatus:
    """ 存储池状态
    """
    NORMAL = 0  # 正常
    DEGRADED = 7  # 降级


class RestType:
    """ rest 命令类型
    """
    GET = 0
    POST = 1


class ErorCode:
    INSURFFICIENT_USER_RIGHTS = '1077949058'  # 用户权限不足
    CONNECT_FAILED = '1077949069'  # 连接中断


class NodeStatus:
    """ 节点状态
    """
    NORMAL = 0  # 正常
