# -*- coding: UTF-8 -*-

import utils
import rest_util
import service_utils
from constants import Result
from constants import Timeout
from constants import RestType


def execute(context):
    """
    离线节点的入口函数
    :param context: 上下文信息
    :return: PASS：离线成功；NOT_PASS:离线失败
    """
    logger = context.get("logger")
    lang = context.get("lang")

    try:
        if service_utils.check_node_is_offline(context):
            return Result.PASS, ""

        return check_task_result(context)
    except Exception as e:
        logger.info("pre_check exception:" + str(e))
        return Result.NOT_PASS, utils.get_msg(lang, "stop.service.failed")


def check_task_result(context):
    logger = context.get("logger")
    r_lock = context.get("rLock")
    try:
        r_lock.lock()
        logger.info("start exec top service:" + context.get("managementIP"))
        flag, task_id, err_msg = stop_service(context)
        if not flag:
            logger.error("exec stop service func failed.")
            return Result.NOT_PASS, err_msg
        flag, err_msg = rest_util.query_task_status(context, task_id, "stop")
        if not flag:
            logger.error("query task info failed.")
            return Result.NOT_PASS, err_msg
        return Result.PASS, ""
    finally:
        logger.info("end exec top service:" + context.get("managementIP"))
        r_lock.unlock()


def stop_service(context):
    """
    离线节点
    :param context: 上下文信息
    :return: True：执行命令成功；False：执行命令失败
    """
    lang = context.get("lang")
    manage_ip = context.get("managementIP")

    url = "/api/v2/cluster/cluster_node"
    params = dict(stop_service=manage_ip)

    cmd_dict = dict(url=url, params=params, rest_type=RestType.POST,
                    retry=Timeout.DEFAULT_RETRY,
                    interval=Timeout.DEFAULT_INTERVAL)

    flag, data, err_msg = rest_util.exe_rest(context, cmd_dict)
    if not flag:
        err_msg = utils.get_msg(lang, "stop.service.failed")
        return False, "", err_msg
    task_id = data.get("task_id")
    return True, task_id, ""
