# -*- coding: UTF-8 -*-
import json
import utils
from com.huawei.bundleupgrade.service.connection.RestConnPool import getRedFishConnection
from com.huawei.uMate.common.utils.RedfishUtils import getStringAttr
from constants import Result

# 软件预置证书
"""
证书签发类型		                    	                                                
华为PKI签发	
    证书序列号: 5b:dc:00:0b:ba:50:e7:a7	 
    证书Subject字段信息: C = CN, O = Huawei, ST = GuangDong, L = ShenZhen, OU = IT, CN = huawei	    
    证书颁发者信息: C = CN, O = Huawei, CN = Huawei IT Product CA

华为PKI签发	
    证书序列号: 3c:f6:9e:e0:12:14:11:a7	 
    证书Subject字段信息: C = CN, O = Huawei, ST = GuangDong, L = ShenZhen, OU = IT, CN = huawei	    
    证书颁发者信息: C = CN, O = Huawei, CN = Huawei IT Product CA ECDSA P384


自签发	    
    证书序列号: 9f:5c:7e:4c:e3:df:0d:d5	 
    证书Subject字段信息: CN=huawei, OU=IT, O=Huawei, L=ShenZhen, S=GuangDong, C=CN	                
    证书颁发者信息: CN=Server, OU=IT, O=Huawei, L=ShenZhen, S=GuangDong, C=CN


自签发	    
    证书序列号: 07	                     
    证书Subject字段信息: CN=server, OU=IT, O=Huawei, L=ShenZhen, S=Guangdong, C=CN	                
    证书颁发者信息: CN=server, OU=IT, O=Huawei, L=ShenZhen, S=Guangdong, C=CN
"""

software_certificate = {
    '5b dc 00 0b ba 50 e7 a7': [
        {'C': 'CN', 'O': 'Huawei', 'S': 'GuangDong', 'L': 'ShenZhen', 'OU': 'IT', 'CN': 'huawei'},
        {'C': 'CN', 'O': 'Huawei', 'CN': 'Huawei IT Product CA'}
    ],
    '3c f6 9e e0 12 14 11 a7': [
        {'C': 'CN', 'O': 'Huawei', 'S': 'GuangDong', 'L': 'ShenZhen', 'OU': 'IT', 'CN': 'huawei'},
        {'C': 'CN', 'O': 'Huawei', 'CN': 'Huawei IT Product CA ECDSA P384'}
    ],
    '9f 5c 7e 4c e3 df 0d d5': [
        {'CN': 'huawei', 'OU': 'IT', 'O': 'Huawei', 'L': 'ShenZhen', 'S': 'GuangDong', 'C': 'CN'},
        {'CN': 'Server', 'OU': 'IT', 'O': 'Huawei', 'L': 'ShenZhen', 'S': 'GuangDong', 'C': 'CN'}
    ],
    '07': [
        {'CN': 'server', 'OU': 'IT', 'O': 'Huawei', 'L': 'ShenZhen', 'S': 'Guangdong', 'C': 'CN'},
        {'CN': 'server', 'OU': 'IT', 'O': 'Huawei', 'L': 'ShenZhen', 'S': 'Guangdong', 'C': 'CN'}
    ]
}


def get_dict(name, data):
    # 将证书信息整理为一个字典
    caet_dict = {}
    name_data = data.get(name)
    name_data_lists = name_data.split(", ")
    for name_data_list in name_data_lists:
        name_data = name_data_list.split("=")
        caet_dict[name_data[0]] = name_data[1]
    return caet_dict


def check_issuer_equal(issuer_cert, issuer_device):
    # 颁发者信息字段个数不一致,redfish查询出来的字段更多
    cert_set = set(issuer_cert.items())
    device_set = set(issuer_device.items())
    return cert_set.issubset(device_set)


def check_software_certificate(number, issuer_dict, subject_dict, certificate, logger):
    if not certificate.__contains__(number):
        logger.info("The serial number is empty.")
        return False

    # 序列号匹配上再匹配subject和issuer
    subject_issuer = certificate.get(number)
    # 获取subject信息
    if subject_issuer[0] != subject_dict:
        logger.info("The subject is ok.")
        return False
    issuer_ret = check_issuer_equal(subject_issuer[1], issuer_dict)
    logger.info("The issuer is ok.")
    if not issuer_ret:
        return False
    return True


def check_cert(device_entity, logger, lang):
    conn = getRedFishConnection(device_entity)
    huawei_systems_url = "/redfish/v1/Managers"
    huawei_res = conn.executeGet(huawei_systems_url)
    # redfish获取数据失败时返回错误信息
    if huawei_res.isSuccess() is False or huawei_res.getStatusCode().startswith("2") is False:
        logger.info("Information about /redfish/v1/Managers/ cannot be queried.")
        return "{};{}".format(device_entity.getIp(), huawei_res.getErrorMsg())

    # 获取不到数据则为不涉及
    json_res = json.loads(huawei_res.getResult())
    if json_res.get("Members") is None:
        logger.info("Information about /redfish/v1/Managers/ cannot get resource.")
        return ""

    huawei_members = json_res.get("Members", [])
    huawei_system_id_url = ""
    if len(huawei_members) > 0:
        huawei_system_id_url = huawei_members[0].get("@odata.id", "")

    part_cert_url = "/SecurityService/HttpsCert"
    result = conn.executeGet(huawei_system_id_url + part_cert_url)
    # redfish获取数据失败时返回错误信息
    if result.isSuccess() is False or result.getStatusCode().startswith("2") is False:
        logger.info("Information about SecurityService HttpsCert cannot be queried.")
        return "{};{}".format(device_entity.getIp(), result.getErrorMsg())

    server_cert_data = json.loads(getStringAttr(result.getResult(), "X509CertificateInformation", "ServerCert"))
    # 获取证书数据为空则为不涉及
    if server_cert_data is None:
        logger.info("The certificate data is empty.")
        return ""

    # 处理证书数据，获取SerialNumber、Subject、Issuer--颁发者信息
    subject_dict = get_dict("Subject", server_cert_data)
    issuer_dict = get_dict("Issuer", server_cert_data)
    serial_number = server_cert_data.get("SerialNumber")

    # 判断是否为预置证书
    ret = check_software_certificate(serial_number, issuer_dict, subject_dict, software_certificate, logger)
    if ret:
        logger.info("The use of preconfigured software certificates may cause private key disclosure risks.")
        return "{};{}".format(device_entity.getIp(),
                              utils.get_msg(lang, "query.node.status.ibmc_ssl_risk"))
    return ""


def execute(context):
    lang = context.get("lang")
    logger = context.get("logger")
    device_entity_list = context.get("selectedDevices")
    results = []
    for device_entity in device_entity_list:
        results.append(check_cert(device_entity, logger, lang))
    if len(results) > 0:
        return Result.NOT_PASS, u"\n".join(results)
    return Result.PASS, ""
