# -*- coding: UTF-8 -*-

import rest_util
from constants import Timeout
from constants import RestType


def check_node_is_offline(context):
    """
    检查是否处于离线状态
    :param context: 上下文信息
    :return: True：离线状态；False：上线状态失败
    """
    logger = context.get("logger")
    device = context.get("deviceEntity")
    url = "/api/v2/cluster/servers"
    cmd_dict = dict(url=url, rest_type=RestType.GET,
                    retry=Timeout.DEFAULT_RETRY,
                    interval=Timeout.DEFAULT_INTERVAL)
    flag, data, err_msg = rest_util.exe_rest(context, cmd_dict)
    select_node_manage_ip = context.get("managementIP")
    logger.info("select_node_manage_ip:" + select_node_manage_ip)
    for node in data:
        logger.info("management_ip:" + node["management_ip"])
        if select_node_manage_ip != node["management_ip"]:
            continue
        if node["running_status"] == "offline":
            logger.info(
                "current node:" + device.getDeviceEntity().getIp() + " is offline")
            return True
        else:
            logger.info(
                "current node:" + device.getDeviceEntity().getIp() + " is online")
            return False
