# -*- coding: UTF-8 -*-

import resource


def get_msg(lang, msg, args="", resource=resource.MESSAGES_DICT):
    """
    消息国际化
    :param lang: 语言
    :param msg: 消息
    :param args: 消息参数
    :param resource: 消息字典
    :return: 经过国际化处理后的消息
    """
    err_msg = "\n--"

    try:
        if msg not in resource:
            return err_msg

        locale_dict = resource.get(msg)
        if lang not in locale_dict:
            return err_msg

        locale_msg = locale_dict.get(lang)
        if "%s" in locale_msg or "%i" in locale_msg:
            return locale_msg % args
        else:
            return locale_msg
    except Exception:
        return err_msg
