# -*- coding: UTF-8 -*-


class ExecResult:
    """
    the BundleUpgradeResult: python execution results.
    """
    PASS = 0
    WARNING = 1
    FAILED = 2


class RedFishTaskStateType:
    """
    the redFish upgrade task status type
    """
    DONE = 0
    PROCESSING = 1


RedFishTaskState = {"New": RedFishTaskStateType.PROCESSING,
                    "Starting": RedFishTaskStateType.PROCESSING,
                    "Running": RedFishTaskStateType.PROCESSING,
                    "Suspended": RedFishTaskStateType.PROCESSING,
                    "Interrupted": RedFishTaskStateType.DONE,
                    "Pending": RedFishTaskStateType.PROCESSING,
                    "Stopping": RedFishTaskStateType.PROCESSING,
                    "Completed": RedFishTaskStateType.DONE,
                    "Killed": RedFishTaskStateType.DONE,
                    "Exception": RedFishTaskStateType.DONE,
                    "Service": RedFishTaskStateType.PROCESSING, }


class RedFishResources:
    DO_UPGRADE = "/redfish/v1/UpdateService/Actions/UpdateService.SimpleUpdate"


class ServerConstants:
    REMOTE_TEMP_DIR = "/tmp/"
    REMOTE_HPM_FILE_PATH = "/tmp/image.hpm"
    HPM_FILE_NAME = "image.hpm"


class HttpMethods:
    GET = "GET"
    POST = "POST"
    PATCH = "PATCH"
    DELETE = "DELETE"


class ModuleConstants:
    """
    the ModuleConstants.
    """
    MODULE_BMC = "iBMC"
    MODULE_BIOS = "BIOS"
    MODULE_CPLD = "CPLD"
    MODULE_RAID = "RAID"
    MODULE_FC_CARD = "FC"
    MODULE_IB_CARD = "IB"
    MODULE_NIC = "NIC"
    MODULE_PSU = "PSU"


class SNMPCommandType:
    """
    the SNMP Command Type
    """
    CMD_TYPE_SET = "SET"
    CMD_TYPE_PUT = "PUT"
    CMD_TYPE_GET = "GET"


ACTIVE_MODE_ZERO = "0"
ACTIVE_MODE_ONE = "1"
ACTIVE_MODE_TWO = "2"
IPMI_CMD_ACTIVE_MODE_PLACEHOLDER = {ACTIVE_MODE_ZERO: "0x0e",
                                    ACTIVE_MODE_ONE: "0x8e"}

"""
the upgrade command parameters
"""
IPMI_CMD_MODULE_PLACEHOLDER = {ModuleConstants.MODULE_BMC: "0x01",
                               ModuleConstants.MODULE_BIOS: "0x02",
                               ModuleConstants.MODULE_CPLD: "0x05",
                               ModuleConstants.MODULE_PSU: "0x00"}
IPMI_CMD_UNKNOWN_MODULE_PLACEHOLDER = "0x00"

REMOTE_TMP_PATH_IPMI_CMD_PARAM = "0x2f 0x74 0x6d 0x70 0x2f 0x69 0x6d " \
                                 "0x61 0x67 0x65 0x2e 0x68 0x70 0x6d"
RAW_IPMI_UPGRADE_CMD = "raw 0x30 0x91 0xdb " \
                       "0x07 0x00 0x06 0xAA 0x00 %s 0x00 %s " \
                       + REMOTE_TMP_PATH_IPMI_CMD_PARAM
RAW_IPMI_CHECK_UPGRADE_CMD = "raw 0x30 0x91 0xdb 0x07 0x00 0x06 0x00"

RAW_IPMI_CHECK_PSU_UPGRADE_DETAIL_CMD = \
    "raw 0x30 0x91 0xdb 0x07 0x00 0x06 0x01"

RAW_IPMI_STOP_ON_ACTIVE_MODE_ONE_CMD = "raw 0x30 0x91 0xdb 0x07 0x00 0x06 0x55"

IPMI_CMD_SUCC_FLAG = "db 07 00"

IPMI_UPGRADE_RETRY_INTERVAL = 15  # in seconds

UPGRADE_TIMEOUT_DEFAULT_INTERVAL = 1800

UPGRADE_TIMEOUT_SHORTEN_INTERVAL = 1200

INT_3 = 3

SFTP_UPLOAD_RETRY_INTERVAL = 15

IPMI_UPGRADE_CMD_ERROR_CODE_DICT = {
    '0x80': 'target.is.upgrading.please.wait',
    '0x81': 'unknown.upgrade.error',
    '0x82': 'upgrade.file.not.exist.please.restart.task',
    '0x83': 'upgrade.file.error',
    '0x84': 'insufficient.iBMC.memory',
    '0x86': 'iBMC.upgrade.space.insufficient',
    '0x87': 'upgrade.file.name.conflict',
    '0x88': 'Bios.8M upgrade.power.on.not.support.',
    '0x8C': 'firmware.package.does.not.match',
    '0x89': 'firmware.version.does.not.match.',
    '0x8B': 'physical.partitioning.is.powered.on',
    '0x8D': 'ME.status.incorrect.BIOS.upgrade.not.supported',
    '0x8E': 'Unknown.error',
    '0x8F': 'Upgrade.is.not.supported.',
    '0x91': 'remote.EM.fails.to.be.upgraded',
    '0x92': 'extra.check.before.the.EM.upgrade.fails',
    '0x93': 'fan.module.subrack.fails.upgraded',
    '0x94': 'Unkown.iBMC.error',
    '0x95': 'fan.modules.partially.upgraded.',
}
IPMI_PSU_UPGRADE_ERROR_CODE_DICT = {
    "0x96": 'Unknown.upgrade.error',
    "0x97": 'current.status.not.support.upgrade',
    "0x9A": 'Other.power.supply.modules.fail.upgraded',
    "0x98": 'number.of.power.supply.modules.cannot.support.overall.power',
    "0x99": 'power.model.upgrade.file.version.Check.incorrect'
}
IPMI_UPGRADE_CMD_SUCCESS_CODE_DICT = {"0x00": 'Upgrade succeed.', }

ALLOW_MAX_SNMP_ERROR = 5
SNMP_CMD_RETRY_INTERVAL = 15  # seconds
SNMP_CMD_REQUEST_TIMEOUT = "time out"
SNMP_UPGRADE_CMD = "1.3.6.1.4.1.2011.2.235.1.1.30.1.0"
SNMP_CHECK_UPGRADE_CMD = "1.3.6.1.4.1.2011.2.235.1.1.30.2.0"

SNMP_UPGRADE_CMD_ERROR_CODE_DICT = {
    '-4': 'invalid.URI.or.file.not.exist',
    '-5': 'file.upload.failed',
    '-6': 'file.too.large.or.memory.not.enough',
    '-7': 'invalid.upgrade.package',
    '-8': "not.support.upgrade.in.current.state",
    '-9': "upgrade.failed",
    '-11': 'BIOS.upgrade.fails.ME.status.not.correct',
    '-12': 'Unknown.error',
    '-13': 'The.version.of.the.pack.not.match.current.web.interface',
    '-10': 'upgrade.file.does.not.match.device',
}
