# -*- coding: UTF-8 -*-
import os
import time
from constants import upg_constants
from resource_bundle import ResourceBundle
import java.lang.Exception as JException
from user_sensible_exceptions import UserException


class FileUploader:
    def __init__(self, context):
        """
        Do upload files using SFTP protocol
        :param context: context
        """
        self.context = context
        self.logger = context.get("logger")
        self.device = context.get("device")
        self.ssh_sftp = context.get("ssh_and_sftp")
        self.res = ResourceBundle(context)

    def upload_using_sftp(self, local_file_path, target_firmware_location):
        """
        upload hpm files to remote using sftp protocol
        :param local_file_path:  local_file_path
        :param target_firmware_location: remote file location
        :raises UserSensibleException
        """
        if not os.path.exists(local_file_path):
            self.logger.error("error: local firmware file does not exist!")
            raise UserException(self.res.get_resource(
                "target.hpm.file.not.exist"))
        for _ in range(3):
            try:
                self.ssh_sftp.delete(upg_constants
                                     .ServerConstants.REMOTE_TEMP_DIR,
                                     upg_constants.ServerConstants
                                     .HPM_FILE_NAME, False)
                self.logger.info(
                    "now start to upload the firmware package from "
                    "%s to remote dir %s." % (
                        local_file_path, target_firmware_location))
                self.ssh_sftp.upload(target_firmware_location, local_file_path,
                                     True)
                self.logger.info("file uploaded successfully.")
                return
            except JException as jexcp:
                self.logger.error(
                    "java exception occurred on upload files: %s,\n retry...."
                    % jexcp.toString())
            time.sleep(upg_constants.SFTP_UPLOAD_RETRY_INTERVAL)
        self.logger.error("SFTP upload failed with max retry times, quit.")
        raise UserException(self.res.get_resource(
            "sftp.upload.failed"))
