# -*- coding: UTF-8 -*-
import os
from user_sensible_exceptions import UserException
from resource_bundle import ResourceBundle
from upgrade_profile_entity import DeviceUpgradeProfile
from defusedxml import ElementTree as ElementTree


class ProfileParser:
    """
    the ProfileParser class: parsing profile.xml
    """

    def __init__(self, context):
        """
        initiator here
        :param context: java diction
        """
        self.logger = context.get("logger")
        self.context = context
        self.file_path = self.context.get("profile")
        self.res = ResourceBundle(context)

        if not os.path.exists(self.file_path):
            raise UserException(
                self.res.get_resource("profile.parsing.error.file.not.exist"))

    def get_profile_details(self):
        """
        get the profile.xml's content
        :return: instance of DeviceUpgradeProfile
        """
        element_tree = ElementTree.parse(self.file_path)
        root = element_tree.getroot()
        active_mode = root.find("ActiveMode") is not None and root.find(
            "ActiveMode").text or ""
        self.logger.info("active_mode: %s" % active_mode)
        firmware_path = root.find("FW") is not None \
            and root.find("FW").text or ""
        self.logger.info("extracted firmware package path: %s" % firmware_path)
        if active_mode and firmware_path:
            upgrade_profile = DeviceUpgradeProfile(active_mode, firmware_path)
            return upgrade_profile
        raise UserException(
            self.res.get_resource("get.profile.failed"))
