# -*- coding: UTF-8 -*-

import os


def singleton(cls):
    _instance = {}

    def _singleton(*args, **kargs):
        if cls not in _instance:
            _instance[cls] = cls(*args, **kargs)
        return _instance[cls]

    return _singleton


@singleton
class ResourceBundle:
    """
    the resource file parser for current sub-tool.
    """

    def __init__(self, context):
        """
        the initiator
        :param context: refer to.
               OutBandUpgradeServiceServiceImpl buildScriptEnvs
        """
        self.language = context.get("lang", "zh")
        self.logger = context.get("logger")
        self.logger.info("current device's language: %s." % self.language)
        self.package_dir = context.get("package_dir")
        self.resource = {}
        self._parse_resource_properties(self.language)

    def get_resource(self, key, *args):
        """
        get international resource echos.
        :param key: key
        :return: international resource(str)
        """
        if args:
            return self.resource.get(key, '') % args
        else:
            return self.resource.get(key, '')

    def _parse_resource_properties(self, language):
        """
        parse for resource properties with specified language.
        :param language: language
        :return: self.resource
        """
        if language == 'zh':
            file_name = 'resource_zh.properties'
        else:
            file_name = 'resource_en.properties'
        file_location = self.package_dir + 'resource' + os.sep + file_name
        self.logger.info("target resource bundle file : %s." % file_location)
        with open(file_location, 'r') as resource_file:
            for line in resource_file.readlines():
                line = line.strip()
                if line.startswith('#') or '=' not in line:
                    continue
                key = line.split('=')[0]
                value = (line.split('=')[1]).decode('unicode_escape') \
                    if language == 'zh' else line.split('=')[1]
                self.resource.setdefault(key, value)
