# coding=utf-8
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re
import traceback

CLI = None
LANGUAGE = None
IP_ADDR = None


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    # 初始化数据
    name = "Not FusionSphere"
    devType = "Not Found"
    sn = ""
    version = ""

    try:
        # 获取设备版本号信息
        sn = str(get_serial_number())
        op_sys_info = CLI.execCmdWithTimout("cat /opt/galax/version/GalaxVersion.cfg", 60)
        pattern = re.compile(
            r"V\d{3}R\d{3}C\d{2}RC\S{1,2}|V\d{3}R\d{3}C\d{2}SPC\S{3}|V\d{3}R\d{3}C\d{2}SPH\S{3}|V\d{3}R\d{3}C\d{2}CP\S{4}|V\d{3}R\d{3}C\d{2}HP\S{4}|V\d{3}R\d{3}C\d{2}")
        pattern2 = re.compile(r"[\d]{1,10}.[\d]{1,10}.[\d]{1,10}")
        verfusionCpGroups = pattern2.findall(op_sys_info)
        verGroups = pattern.findall(op_sys_info)
        if not verGroups and not verfusionCpGroups:
            return {"name": name, "type": devType, "sn": sn, "version": version}
        elif verGroups:
            version = devType = verGroups[0]
        else:
            version = devType = verfusionCpGroups[0]

        # 获取设备其他信息
        name = 'FusionSphere'
    except:
        return {"name": name, "type": devType, "sn": sn, "version": version}
    # 数据返回
    return {"name": name, "type": devType, "sn": sn, "version": version}


def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S', time.localtime(time.time()))
    t = t.replace('-', '')
    return t


def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = ''
    if_config_str = CLI.execCmdWithTimout("/sbin/ifconfig", 60)
    ip_link_show = CLI.execCmdWithTimout("/sbin/ip link show", 60)

    if ip_link_show.find("TOOLKIT_EXE_CMD_FAILED") > 0:
        ip_link_show = CLI.execCmdWithTimout("ip link show", 60)

    temp_list = if_config_str.splitlines()
    temp_list_2 = ip_link_show.splitlines()

    for i in range(0, len(temp_list)):
        if IP_ADDR in temp_list[i]:
            eth_name = temp_list[i - 1].split()[0]
            if eth_name.find(":") >= 0:
                eth_name = eth_name.split(':')[0]

            eth_name = eth_name.split(':')[0]
            for i in range(0, len(temp_list_2)):
                if eth_name in temp_list_2[i]:
                    mac_address = temp_list_2[i + 1].split()[1]
                    break
            mac_arr = mac_address.strip().split(':');
            for mac in mac_arr:
                if (len(mac) == 1):
                    mac_str = "0"
                else:
                    mac_str += mac
            if "0" == mac_str:
                serial_number = get_time_str() + IP_ADDR
            else:
                serial_number = mac_str + IP_ADDR
            fun_flag = CHECK_PASS
            break
    if '' == serial_number:
        serial_number = "SN" + get_time_str() + IP_ADDR
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."

    serial_number = serial_number.replace('.', '')
    return serial_number
