# -*- coding: UTF-8 -*-
"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re

CLI = None
LANGUAGE = None
IP_ADDR = None

#交换机型号
display_cmd_command="show version"

def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = "QLogic"
    dev_type = check_and_get_result(getSwitchType())
    sn = check_and_get_result(getSwitchWWN())
    version = check_and_get_result(getSwitchVersion())

    return {"name": name, "type":dev_type, "sn": sn, "version": version}

# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)
    
def getSwitchType():
    '''
    @summary: 获取交换机 型号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机类型
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchType = ""
    arrayIndex = -1;
    for line in cli_ret_list:
        if "SystemDescription" in line:
            line=line.replace("SystemDescription","")
            line=line.strip()
            switchType=line
    # here
    if len(switchType) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机类型失败。"
        else:
            fun_err_msg = "Get switch type failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchType, fun_err_msg


def getSwitchVersion():
    '''
    @summary: 获取交换机版本号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机版本号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
  
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    
    switchVersion = ""
    for line in cli_ret_list:
        if "ActiveSWVersion" in line:
            line=line.replace("ActiveSWVersion","")
            line=line.strip()
            switchVersion=line
    # here
    if len(switchVersion) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机版本号失败。"
        else:
            fun_err_msg = "Get switch version failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchVersion, fun_err_msg

def getSwitchWWN():
    '''
    @summary: 获取交换机WWN号
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag: 
            True： 判断时正常
            False： 判断时异常
        ret: 
            flag为True时，交换机WWN号
            flag为False时，返回cli回显
        errMsg: 错误时的消息
    '''   
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdNoLogTimout(display_cmd_command, 60)
    cli_ret_list = cli_ret.splitlines()
    for line in cli_ret_list:
        if "WorldWideName" in line:
            line=line.replace("WorldWideName","")
            line=line.strip()
            switchWwn=line
    if len(switchWwn) == 0:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取交换机类型失败。"
        else:
            fun_err_msg = "Get switch type failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, switchWwn, fun_err_msg