
window.onload = function(){

    var selectOption;
    
    if (null !== document.getElementById("filter"))
    {
            selectOption = document.getElementById("filter");
    }
    else
    {
            selectOption = document.getElementById("select");
    }
    /**
     * 在巡检报告中，过滤出不通过的项，点击过滤出来的检查项跳转到详细页面，
     * 然后点击浏览器的返回按钮后，过滤器中显示的是过滤不通过的项，但界面显示了所有检查项
     */
    selectOption.options[0].selected = true;
    $('#end').hide();
}

window.onbeforeunload = function(){
     $('body').remove();
}

function isSelected(value) {
    //所有的巡检项不包含start和end
    var all = $("#start").nextUntil("#end");
    //end:nodata项
    var end = $('#end');
    
    $(end).hide();
    
    if (!value) 
    {
        $(all).children().show();
    }
    else
    {
        $(all).children().hide();
        //选中的巡检项
        var select = $('body').find('div[name*="' + value + '"]');
        
        if($(select).length !==0)
        {
            $(select).show();
        }
        else
        {
            $(end).show();
        }
    }
}
//summary过滤
function filter(value) {

    //所有的巡检项，包含end
    var all = $('#showAll').find('tr:gt(1)');
    //end:nodata项
    var end = $('#end');
   
    if (!value) 
    {
        $(all).show();
        $(end).hide();
    } 
    else
    {
        var select =  $('tr[name*="' + value + '"]');
        
        $(all).hide();

        if( $(select).length!==0)
        {
            $(select).show();
        }
        else
        {
            $(end).show();
        }
    }
    
    var gaps = $('tr[name = gap]');


    chunk(gaps,setVisible,20);
}
//预警和基线过滤
function pw_filter(value) {
	
	$("div").each(function(){
		
		switch ($(this).attr("id")){
			case "Common":
				common_filter(value);
				break;
			case "E9000":
				e9000_filter(value);
				break;
			case "OS":
				os_filter(value);
				break;
			default:
				break;
		}
	});

}



function common_filter(value){
	 //所有的预警版本
    var all = $('#Common').find('tr[name!="gap_common"]:gt(1)');
	//end:nodata项
    var end = $('#Common').find("tr[name='end']");
	
    if (!value) 
    {
        $(all).show();
		$(end).hide();
    } 
    else
    {
		var select =  $('#Common').find('tr[name*="' + value + '"]');
		
		$(all).hide();
		
		if( $(select).length!==0)
        {
            $(select).show();
        }
        else
        {
            $(end).show();
        }
    }
    
	var gap_common = $('#Common').find('tr[name = gap_common]');


    pw_chunk(gap_common,pw_setVisible,20,'common');

}

function e9000_filter(value){
	 //所有的预警版本
    var all = $('#E9000').find('tr[name!="gap_board"][name!="gap_e9000"]:gt(1)');
	//end:nodata项
    var end = $('#E9000').find("tr[name='end']");
	
    if (!value) 
    {
        $(all).show();
		$(end).hide();
    } 
    else
    {
        var select =  $('#E9000').find('tr[name*="' + value + '"]');
		
		$(all).hide();
		
		if( $(select).length!==0)
        {
            $(select).show();
        }
        else
        {
            $(end).show();
        }
    }
    
	var gap_board = $('#E9000').find('tr[name = gap_board]');
	var gap_e9000 = $('#E9000').find('tr[name = gap_e9000]');


    pw_chunk(gap_board,pw_setVisible,20,'board');
	pw_chunk(gap_e9000,pw_setVisible,20,'e9000');

}

function os_filter(value){
	 //所有的预警版本
    var all = $('#OS').find('tr[name!="gap_bus"][name!="gap_card"][name!="gap_os"]:gt(1)');
	//end:nodata项
    var end = $('#OS').find("tr[name='end']");
	
    if (!value) 
    {
        $(all).show();
		$(end).hide();
    } 
    else
    {
        var select =  $('#OS').find('tr[name*="' + value + '"]');
		
		$(all).hide();
		
		if( $(select).length!==0)
        {
            $(select).show();
        }
        else
        {
            $(end).show();
        }
    }
    
	var gap_bus = $('#OS').find('tr[name = gap_bus]');
	var gap_card = $('#OS').find('tr[name = gap_card]');
	var gap_os = $('#OS').find('tr[name = gap_os]');


    pw_chunk(gap_bus,pw_setVisible,20,'bus');
	pw_chunk(gap_card,pw_setVisible,20,'card');
	pw_chunk(gap_os,pw_setVisible,20,'os');

}

//逐步加载，步进为step
function chunk(array,process,step){
    setTimeout(function(){
        restArray= array.splice(0,step);
        process(restArray); //循环体要做的操作
        if( restArray.length!=0 ){
			setTimeout(arguments.callee,0);
        }
    });
}
//逐步加载，步进为step
function pw_chunk(array,process,step,str){
    setTimeout(function(){
        restArray= array.splice(0,step);
        process(restArray,str); //循环体要做的操作
        if( restArray.length!=0 ){
			setTimeout(arguments.callee,0);
        }
    });
}
//计算预警item可见的个数并设置rowspan
function pw_setVisible(value,str){
    var len = value.length; //这里要注意在执行过程中数组最好是不变的
    for(var index =0;index<len;index++){
        var data = $(value[index]).nextUntil('tr[name = gap_'+str+']').filter(':visible');
        var count = data.length;
        //显示第一个，隐藏其余的
        $(data).find('td[name = '+str+']').hide();
		
        $(data).first().find('td[name = '+str+']').attr('rowspan',count);
        $(data).first().find('td[name = '+str+']').show();
    }
 
}
//计算parent item可见的个数并设置rowspan
function setVisible(value){
    var len = value.length; //这里要注意在执行过程中数组最好是不变的
    for(var index =0;index<len;index++){
        var data = $(value[index]).nextUntil('tr[name = gap]').filter(':visible');
        var count = data.length;
        //显示第一个，隐藏其余的
        $(data).find('td[name = parent]').hide();

        $(data).first().find('td[name = parent]').attr('rowspan',count);
        $(data).first().find('td[name = parent]').show();
    }
 
}