/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.infocollect.device.application;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.infocollect.entity.CollectStatus;
import com.huawei.ism.tool.infocollect.rest.device.domain.entity.SupportDevice;
import com.huawei.ism.tool.infocollect.rest.device.domain.service.SupportDeviceService;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.task.domain.entity.CollectProgress;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.rest.controller.BaseDeviceController;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.ism.tool.service.rest.service.device.SshProxyConfigService;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import com.huawei.smartkit.infocollect.device.application.InfoCollectObserverService;
import com.huawei.smartkit.infocollect.device.application.InfoCollectSupportService;
import com.huawei.smartkit.infocollect.device.domain.entity.AddDeviceForm;
import com.huawei.smartkit.infocollect.device.domain.entity.InfoCollectDevice;
import com.huawei.smartkit.infocollect.task.application.CollectTaskRestService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class DeviceService {
    private static final Logger log = LoggerFactory.getLogger(DeviceService.class);
    private final BaseDeviceController baseDeviceController = new BaseDeviceController((INodeSupport)new InfoCollectSupportService(), (INodeObserver)new InfoCollectObserverService());
    private CollectTaskRestService taskRestService = new CollectTaskRestService();

    public List<SupportDevice> querySupportList() {
        return new SupportDeviceService().querySupportDevice();
    }

    public DevNodeVO addDevice(@RequestBody AddDeviceForm node) throws InfoCollectException {
        Response response;
        if (!StringUtils.isNULLStr((String)node.getProxyNodeId()) && !"none".equals(node.getProxyNodeId())) {
            node.setSshForwardList(SshProxyConfigService.INS.getSSHRouteList(node.getProxyNodeId()));
        }
        if ((response = this.baseDeviceController.login((DevNode)node)).isFailed()) {
            throw new InfoCollectException(response.getResult().getDescription());
        }
        DevNodeVO devNodeVO = (DevNodeVO)response.getData();
        devNodeVO.setStatus(Status.UN_EXECUTE.toString());
        com.huawei.ism.tool.framework.pubservice.entity.DevNode dev = new com.huawei.ism.tool.framework.pubservice.entity.DevNode();
        dev.setDeviceType(DeviceType.valueOf((String)devNodeVO.getProductModel()));
        dev.setProductVersion(devNodeVO.getProductVersion());
        return (DevNodeVO)response.getData();
    }

    public List<? extends DevNodeVO> queryAddedDevice() {
        return BusinessDeviceUtil.INS.filterDevNodeByINodeSupport((INodeSupport)new InfoCollectSupportService()).stream().map(InfoCollectDevice::new).peek(arg_0 -> this.queryAndSetCollectStatus(arg_0)).collect(Collectors.toList());
    }

    private void queryAndSetCollectStatus(InfoCollectDevice device) {
        try {
            CollectProgress collectProgress = this.taskRestService.queryProgressById(device.getSn());
            CollectStatus status = collectProgress.getStatus();
            device.setStatus(status == null ? CollectStatus.NOT_COLLECT.name() : status.name());
            device.setProgress(collectProgress.getProgress());
        }
        catch (InfoCollectException e) {
            log.error("query device status error", (Throwable)e);
        }
    }
}

