/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.infocollect.item.adapter;

import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.SecondConfirmResult;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.smartkit.infocollect.item.application.CollectItemRestService;
import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"item"})
public class CollectItemController {
    private CollectItemRestService collectItemRestService;

    @GetMapping(value={"{id}"})
    public Response<StorageItemSetting> queryItemById(@PathVariable String id, @ModelAttribute CollectItemQuery param) throws InfoCollectException {
        return Response.success((Object)this.collectItemRestService.queryItemById(id, param));
    }

    @PostMapping(value={"{id}"})
    public Response<?> saveCollectItem(@RequestBody CollectItemSaveSetting param, @PathVariable String id) throws InfoCollectException {
        this.collectItemRestService.saveItemBySn(id, param);
        return Response.success((Object)param);
    }

    @GetMapping(value={"confirm/{id}"})
    public Response<?> querySecondConfirmById(@PathVariable String id, String item) throws InfoCollectException {
        return Response.success((Object)this.collectItemRestService.querySecondConfirmData(id, item));
    }

    @PostMapping(value={"confirm/{id}"})
    public Response<?> saveSecondConfirmById(@PathVariable String id, @RequestBody SecondConfirmResult param) throws InfoCollectException {
        this.collectItemRestService.saveSecondConfirmItem(id, param);
        return Response.success();
    }

    public CollectItemController(CollectItemRestService collectItemRestService) {
        this.collectItemRestService = collectItemRestService;
    }
}

