/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.infocollect.item.application;

import com.huawei.ism.tool.infocollect.rest.context.InfoCollectLock;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemQuery;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.CollectItemSaveSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.SecondConfirmResult;
import com.huawei.ism.tool.infocollect.rest.item.domain.entity.StorageItemSetting;
import com.huawei.ism.tool.infocollect.rest.item.domain.service.CollectItemService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectItemRestService {
    private static final Logger log = LoggerFactory.getLogger(CollectItemRestService.class);
    private final CollectItemService collectItemService = new CollectItemService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageItemSetting queryItemById(String id, CollectItemQuery param) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(id);
        if (!InfoCollectLock.getInstance().tryLock(id)) {
            throw new InfoCollectException("device_is_operating");
        }
        try {
            StorageItemSetting storageItemSetting = this.collectItemService.queryCollectItem(devNode, param);
            return storageItemSetting;
        }
        finally {
            InfoCollectLock.getInstance().unLock(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItemBySn(String id, CollectItemSaveSetting param) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(id);
        if (!InfoCollectLock.getInstance().tryLock(id)) {
            throw new InfoCollectException("device_is_operating");
        }
        try {
            this.collectItemService.saveCollectItemSetting(devNode, param);
        }
        finally {
            InfoCollectLock.getInstance().unLock(id);
        }
    }

    private DevNode queryDevNode(String sn) throws InfoCollectException {
        Optional dev = BusinessDeviceUtil.INS.findBusinessDev(sn);
        if (!dev.isPresent()) {
            log.warn("{} can't find", (Object)sn);
            throw new InfoCollectException("device.not.exit");
        }
        return ((BusinessDevice)dev.get()).getDevNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object querySecondConfirmData(String id, String item) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(id);
        if (!InfoCollectLock.getInstance().tryLock(id)) {
            throw new InfoCollectException("device_is_operating");
        }
        try {
            Object object = this.collectItemService.querySecondConfirmData(devNode, item);
            return object;
        }
        finally {
            InfoCollectLock.getInstance().unLock(id);
        }
    }

    public void saveSecondConfirmItem(String id, SecondConfirmResult param) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(id);
        this.collectItemService.saveSecondConfirmItem(devNode, param);
    }
}

