/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.infocollect.system.application;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.util.InfoCollectDirPropertiesUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.smartkit.infocollect.system.domain.InfoCollectSystemSetting;
import com.huawei.smartkit.river.toolboxservice.businessbase.adapter.Response;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

@Service
public class SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemService.class);

    public InfoCollectSystemSetting querySystemSetting() {
        return InfoCollectSystemSetting.builder().os(ApplicationContext.getInstance().isWindowsOS() ? "windows" : "linux").collectSavePath(InfoCollectDirPropertiesUtil.getProperty()).language(ApplicationContext.getInstance().isEnglishEnv() ? "en" : "zh").build();
    }

    @PostMapping(value={"collect-file-path"})
    public Response<?> saveCustomerSavePath(@NotNull String path) throws InfoCollectException {
        this.checkPath(path);
        try {
            InfoCollectDirPropertiesUtil.setProperty((String)path);
        }
        catch (ToolException e) {
            log.error("save collect file path({}) fail", (Object)path, (Object)e);
            throw new InfoCollectException("set.path.fail");
        }
        return Response.success();
    }

    private void checkPath(String path) throws InfoCollectException {
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            throw new InfoCollectException("not.allow.set.path.not.in.windows");
        }
        File file = new File(path);
        if (!file.isDirectory()) {
            throw new InfoCollectException("not.allow.set.path.not.dir");
        }
        File testFile = new File(path + File.separator + "test.txt");
        try {
            if (!testFile.createNewFile()) {
                log.error("{} can't create file", (Object)testFile.getPath());
                throw new InfoCollectException("dir.not.allow.create.file");
            }
            testFile.delete();
        }
        catch (IOException e) {
            log.error("create test file error.", (Throwable)e);
            throw new InfoCollectException("dir.not.allow.create.file");
        }
    }
}

