/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.infocollect.task.application;

import com.huawei.ism.tool.infocollect.rest.context.InfoCollectCache;
import com.huawei.ism.tool.infocollect.rest.context.InfoCollectLock;
import com.huawei.ism.tool.infocollect.rest.exception.InfoCollectException;
import com.huawei.ism.tool.infocollect.rest.task.domain.entity.CollectProgress;
import com.huawei.ism.tool.infocollect.rest.task.domain.service.CollectTaskService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectTaskRestService {
    private static final Logger log = LoggerFactory.getLogger(CollectTaskRestService.class);
    private final CollectTaskService taskService = new CollectTaskService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(List<String> deviceIds) throws InfoCollectException {
        List devs = this.getAllDev(deviceIds);
        List<String> lockSuccessDevIds = deviceIds.stream().filter(deviceId -> InfoCollectLock.getInstance().tryLock(deviceId)).collect(Collectors.toList());
        try {
            List getLockFailDev = devs.stream().map(DevNode::getDeviceSerialNumber).filter(deviceSerialNumber -> !lockSuccessDevIds.contains(deviceSerialNumber)).collect(Collectors.toList());
            if (!getLockFailDev.isEmpty()) {
                throw new InfoCollectException("device_is_operating_multi", new Object[]{String.join((CharSequence)",", getLockFailDev)});
            }
            this.taskService.startCollectTask(devs);
        }
        finally {
            lockSuccessDevIds.forEach(deviceId -> InfoCollectLock.getInstance().unLock(deviceId));
        }
    }

    private List<DevNode> getAllDev(List<String> deviceIds) throws InfoCollectException {
        List<DevNode> devs = deviceIds.stream().map(sn -> {
            try {
                return this.queryDevNode(sn);
            }
            catch (InfoCollectException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (devs.size() != deviceIds.size()) {
            throw new InfoCollectException("device_not_exit");
        }
        return devs;
    }

    public CollectProgress queryProgressById(String deviceId) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(deviceId);
        return this.taskService.queryTaskProgress(devNode);
    }

    public File download(String deviceId) throws InfoCollectException {
        DevNode devNode = this.queryDevNode(deviceId);
        String path = InfoCollectCache.getInstance().queryCollectResultFile(devNode.getDeviceSerialNumber());
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new InfoCollectException("device.collect.file.empty");
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            throw new InfoCollectException("device.collect.file.illegal");
        }
        return file;
    }

    private DevNode queryDevNode(String sn) throws InfoCollectException {
        Optional dev = BusinessDeviceUtil.INS.findBusinessDev(sn);
        if (!dev.isPresent()) {
            log.warn("{} can't find", (Object)sn);
            throw new InfoCollectException("device.not.exit");
        }
        return ((BusinessDevice)dev.get()).getDevNode();
    }
}

