/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.flow;

import com.huawei.ism.tool.base.flow.FlowContext;
import com.huawei.ism.tool.base.flow.FlowState;
import com.huawei.ism.tool.base.flow.ICondition;
import com.huawei.ism.tool.base.flow.IFlow;
import com.huawei.ism.tool.base.flow.IFlowListener;
import com.huawei.ism.tool.base.flow.IStep;
import com.huawei.ism.tool.base.flow.StepPos;
import com.huawei.ism.tool.base.flow.ui.IFlowUI;
import com.huawei.ism.tool.base.flow.ui.Title;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Flow
implements IFlow {
    private static final long serialVersionUID = -346844385002413207L;
    private IFlowUI flowUI;
    private Title title;
    private String help;
    private transient FlowContext context = new FlowContext();
    private transient List<IStep> stepList = new ArrayList<IStep>();
    private transient List<Title> stageTitleList = new ArrayList<Title>();
    private transient IStep curStep = null;
    private transient Stack<IStep> stepTrace = new Stack();
    private transient Set<IFlowListener> listenerList = new HashSet<IFlowListener>();
    private FlowState curState = FlowState.INIT;

    public Flow(Title title) {
        this.title = title;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.context = new FlowContext();
        this.stepList = new ArrayList<IStep>();
        this.stageTitleList = new ArrayList<Title>();
        this.listenerList = new HashSet<IFlowListener>();
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void addStage(int stageIndex, Title stageTitle) {
        this.stageTitleList.add(stageIndex, stageTitle);
    }

    public void setFlowUI(IFlowUI flowUI) {
        this.flowUI = flowUI;
    }

    public void addStep(IStep step) {
        this.stepList.add(step);
    }

    @Override
    public void addListener(IFlowListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void goNext() {
        this.goNext(true, this.curStep);
    }

    private void goNext(boolean needEnding, IStep preStep) {
        if (needEnding && !this.curStep.ending()) {
            return;
        }
        int index = this.stepList.indexOf(this.curStep);
        int nextIndex = index + 1;
        if (nextIndex >= this.stepList.size()) {
            return;
        }
        IStep nextStep = this.stepList.get(nextIndex);
        ICondition condtion = nextStep.getCondition();
        if (null != condtion && !condtion.isMeet(nextStep.getId())) {
            this.curStep = nextStep;
            this.curStep.setContext(this.context);
            if (condtion.isForPrevious()) {
                this.goNext(false, preStep);
            } else {
                this.stepTrace.push(this.curStep);
                this.goNext(false, this.curStep);
            }
            return;
        }
        if (this.forwardToStep(nextStep, nextIndex)) {
            this.stepTrace.push(preStep);
        }
    }

    @Override
    public void goPrevious() {
        if (!this.curStep.canceling()) {
            return;
        }
        if (this.stepTrace.size() == 0) {
            return;
        }
        while (!this.stepTrace.empty()) {
            IStep preStep = this.stepTrace.pop();
            if (preStep.isAuto()) continue;
            this.backToStep(preStep, this.stepTrace.size());
            break;
        }
    }

    @Override
    public boolean init() {
        if (null != this.flowUI) {
            this.flowUI.init(this.title, this.help, this.stageTitleList);
        }
        this.curState = FlowState.READY;
        return true;
    }

    @Override
    public boolean start() {
        IStep step = null;
        int startInx = 0;
        for (IStep st : this.stepList) {
            ICondition condtion = st.getCondition();
            if (null == condtion || condtion.isMeet(st.getId())) {
                step = st;
                break;
            }
            if (condtion.isForPrevious()) continue;
            this.stepTrace.push(st);
            ++startInx;
        }
        if (null == step) {
            return false;
        }
        if (!this.forwardToStep(step, startInx)) {
            return false;
        }
        this.curState = FlowState.RUNNING;
        for (IFlowListener l : this.listenerList) {
            l.onStart();
        }
        return true;
    }

    @Override
    public boolean exit() {
        if (!this.curStep.flowExiting()) {
            return false;
        }
        this.curState = FlowState.STOPPED;
        for (IFlowListener l : this.listenerList) {
            l.onExit(this.curStep);
        }
        return true;
    }

    @Override
    public boolean complete() {
        if (!this.curStep.ending()) {
            return false;
        }
        this.curState = FlowState.STOPPED;
        for (IFlowListener l : this.listenerList) {
            l.onComplete();
        }
        return true;
    }

    @Override
    public FlowState getCurState() {
        return this.curState;
    }

    @Override
    public FlowContext getContext() {
        return this.context;
    }

    private boolean forwardToStep(IStep step, int index) {
        StepPos pos = StepPos.MIDDLE_STEP;
        if (0 == index) {
            pos = StepPos.START_STEP;
        } else if (this.stepList.size() - 1 == index) {
            pos = StepPos.END_STEP;
        }
        if (step.start(this.flowUI, this.context, pos)) {
            this.curStep = step;
            return true;
        }
        return false;
    }

    private boolean backToStep(IStep step, int index) {
        StepPos pos;
        StepPos stepPos = pos = 0 == index ? StepPos.START_STEP : StepPos.MIDDLE_STEP;
        if (step.start(this.flowUI, this.context, pos)) {
            this.curStep = step;
            return true;
        }
        return false;
    }

    public IStep getCurStep() {
        return this.curStep;
    }
}

