/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.treetable;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.component.treetable.DefaultTreeTableCellEditorFactory;
import com.huawei.ism.tool.base.ui.component.treetable.DefaultTreeTableRanderFactory;
import com.huawei.ism.tool.base.ui.component.treetable.ITreeTableCellEditorFactory;
import com.huawei.ism.tool.base.ui.component.treetable.ITreeTableRendererFactory;
import com.huawei.ism.tool.base.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.base.ui.component.treetable.MutliHyperLinkCell;
import com.huawei.ism.tool.base.ui.component.treetable.TreeTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TreeTable
extends IsmTable {
    private static final long serialVersionUID = 1218868642512478375L;
    private static final int HOTSPOT_SIZE = 18;
    private ITreeTableRendererFactory rendererFactory;
    private ITreeTableCellEditorFactory cellEditorFacoty;
    private TableModelListener tableModelListener = null;
    private boolean checkBoxVisiable = false;
    private boolean bChildCheckBoxVisiable = true;
    private boolean isMutiSelect = true;

    public TreeTable(TableModel model, TableModelListener tableModelListener) {
        super(model);
        this.tableModelListener = tableModelListener;
    }

    public TreeTable(TreeTableModel dm) {
        super((TableModel)dm);
        this.setGridColor(UIManager.getColor("Panel.background"));
        this.getSelectionModel().setSelectionMode(0);
        this.setRendererFactory(new DefaultTreeTableRanderFactory());
        this.setEditorFactory(new DefaultTreeTableCellEditorFactory());
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setRowSorter(null);
        this.setSelectionMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new ToggleMouseHandler());
    }

    public TreeTable(TreeTableModel tableModel, boolean isMutiSelection) {
        this(tableModel);
        if (isMutiSelection) {
            this.setSelectionMode(2);
        }
    }

    public TreeTable(TreeTableModel dm, boolean isMutiSelection, boolean isCheckBoxVisiable) {
        this(dm);
        if (isMutiSelection) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
        this.isMutiSelect = isMutiSelection;
        this.checkBoxVisiable = isCheckBoxVisiable;
    }

    public TreeTable(TreeTableModel dm, boolean isMutiSelection, boolean isCheckBoxVisiable, boolean isChildCheckBoxVisiable) {
        this(dm, isMutiSelection, isCheckBoxVisiable);
        this.bChildCheckBoxVisiable = isChildCheckBoxVisiable;
    }

    public boolean isChildCheckBoxVisiable() {
        return this.bChildCheckBoxVisiable;
    }

    public boolean isMutliSelected() {
        return this.isMutiSelect;
    }

    public boolean isCheckBoxVisiable() {
        return this.checkBoxVisiable;
    }

    public void setCheckVisiable(boolean visiable) {
        this.checkBoxVisiable = visiable;
    }

    public void setRendererFactory(ITreeTableRendererFactory factory) {
        this.rendererFactory = factory;
    }

    public void setEditorFactory(ITreeTableCellEditorFactory factory) {
        this.cellEditorFacoty = factory;
    }

    public ITreeTableCellEditorFactory getEditorFactory() {
        return this.cellEditorFacoty;
    }

    public ITreeTableRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public boolean isCellEditable(int row, int column) {
        Object value = this.getValueAt(row, column);
        return value instanceof MutliHyperLinkCell;
    }

    public TableCellEditor getCellEditor(int row, int col) {
        TableCellEditor defaultEditor = this.getEditorFactory().getTableCellEditor((JTable)((Object)this), row, col);
        if (null == defaultEditor) {
            return super.getCellEditor(row, col);
        }
        return defaultEditor;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer defaultRenderer = this.getRendererFactory().getTableCellRenderer((JTable)((Object)this), row, column);
        if (null == defaultRenderer) {
            return super.getCellRenderer(row, column);
        }
        return defaultRenderer;
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.getModel();
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean isSelected;
        Object value = this.getValueAt(row, column);
        Component component = renderer.getTableCellRendererComponent((JTable)((Object)this), value, isSelected = this.isCellSelected(row, column), false, row, column);
        if (null != component) {
            component.setEnabled(true);
        }
        return component;
    }

    public List<ITreeTableRow<?, ?>> getSelectRows() {
        int[] rows = this.getSelectedRows();
        ArrayList rowList = new ArrayList();
        for (int i : rows) {
            TreeTableModel.RowItem rowItem = this.getTreeTableModel().getRowElement(i);
            if (null == rowItem) {
                throw new NullPointerException();
            }
            ITreeTableRow<?, ?> row = rowItem.getTableRow();
            rowList.add(row);
        }
        return rowList;
    }

    public List<ITreeTableRow<?, ?>> getTreeTableMarkedRows() {
        ArrayList rowList = new ArrayList();
        List<TreeTableModel.RowItem> list = this.getTreeTableModel().getAllItemList();
        for (TreeTableModel.RowItem item : list) {
            if (TreeTableModel.SelectType.UNSELECT.equals((Object)item.getSelectType())) continue;
            ITreeTableRow<?, ?> row = item.getTableRow();
            rowList.add(row);
        }
        return rowList;
    }

    public void setModel(TableModel newModel) {
        if (!(newModel instanceof TreeTableModel)) {
            throw new IllegalArgumentException("DataModel must be of type " + TreeTableModel.class.getName());
        }
        super.setModel(newModel);
        newModel.addTableModelListener(this.tableModelListener);
    }

    public boolean isScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    private void updateTableRowStatus(MouseEvent event) {
        TreeTable table = (TreeTable)((Object)event.getComponent());
        int row = table.rowAtPoint(event.getPoint());
        TreeTableModel model = table.getTreeTableModel();
        TreeTableModel.RowItem item = table.getTreeTableModel().getRowElement(row);
        if (null == item) {
            return;
        }
        int indentWidth = table.getCheckBoxLeftIndent(item);
        int xx = event.getX();
        int nu = xx - indentWidth;
        if (nu > 10 && nu < 18) {
            item.toggle();
            return;
        }
        TreeTableModel.RowItem rowItem = model.getRowElement(row);
        if (null == rowItem) {
            throw new NullPointerException();
        }
        this.checkParentNode(event, row, model, xx, rowItem);
    }

    private void checkParentNode(MouseEvent event, int row, TreeTableModel model, int xx, TreeTableModel.RowItem rowItem) {
        if (this.isMutiSelect) {
            if (xx > 36 && xx < 46 && null == rowItem.getParent()) {
                this.updateSubNodes(rowItem, row, model);
            } else if (xx > 56 && xx < 69) {
                this.updateParentNode(rowItem, row, model);
            } else if (xx > 69) {
                this.updateCellEditorByMouseClick(event);
            }
        } else {
            List<TreeTableModel.RowItem> rowItemList = model.getAllItemList();
            for (TreeTableModel.RowItem rI : rowItemList) {
                rI.setSelectType(TreeTableModel.SelectType.UNSELECT);
            }
            TreeTableModel.RowItem parent = rowItem.getParent();
            if (null == parent) {
                parent = rowItem;
            }
            int from = model.getRowItemIndex(parent);
            parent.setSelectType(TreeTableModel.SelectType.SELECT);
            int childSize = parent.getTableRow().getSubRowList().size();
            int to = from + childSize;
            for (int index = from + 1; index <= to && from < to; ++index) {
                TreeTableModel.RowItem subItem = model.getRowElement(index);
                if (null == subItem || !parent.equals(subItem.getParent())) continue;
                subItem.setSelectType(TreeTableModel.SelectType.SELECT);
            }
            model.fireTableRowsUpdated(from, to);
            this.repaint();
        }
    }

    private void updateCellEditorByMouseClick(MouseEvent event) {
        Component component = SwingUtilities.getDeepestComponentAt((Component)((Object)this), event.getX(), event.getY());
        if (component instanceof ToolHyperLinkLabel) {
            MouseListener[] listeners;
            ToolHyperLinkLabel lable = (ToolHyperLinkLabel)component;
            for (MouseListener li : listeners = lable.getMouseListeners()) {
                li.mouseClicked(event);
            }
        }
    }

    private void updateSubNodes(TreeTableModel.RowItem parentRowItem, int row, TreeTableModel model) {
        if (null == parentRowItem) {
            return;
        }
        TreeTableModel.SelectType childRenSelectedType = TreeTableModel.SelectType.SELECT;
        TreeTableModel.SelectType parentSelectType = parentRowItem.getSelectType();
        if (TreeTableModel.SelectType.SELECT == parentSelectType) {
            parentRowItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
            childRenSelectedType = TreeTableModel.SelectType.UNSELECT;
        } else if (TreeTableModel.SelectType.UNSELECT == parentSelectType || TreeTableModel.SelectType.HALF == parentSelectType) {
            parentRowItem.setSelectType(TreeTableModel.SelectType.SELECT);
        }
        int from = row;
        int to = row + parentRowItem.getTableRow().getSubRowList().size();
        List<TreeTableModel.RowItem> itemList = model.getAllItemList();
        for (TreeTableModel.RowItem item : itemList) {
            if (null == item || !parentRowItem.equals(item.getParent())) continue;
            item.setSelectType(childRenSelectedType);
        }
        model.fireTableRowsUpdated(from, to);
    }

    private void updateParentNode(TreeTableModel.RowItem rowItem, int row, TreeTableModel model) {
        rowItem.reverse();
        TreeTableModel.RowItem parent = rowItem.getParent();
        if (null == parent) {
            parent = rowItem;
        }
        int from = model.getRowItemIndex(parent);
        int childSize = parent.getTableRow().getSubRowList().size();
        int to = from + childSize;
        if (!this.isMutiSelect) {
            parent.setSelectType(TreeTableModel.SelectType.SELECT);
        } else {
            int selectedSubItemCount = 0;
            for (int index = from + 1; index <= to && from < to; ++index) {
                TreeTableModel.RowItem subItem = model.getRowElement(index);
                if (null == subItem) {
                    throw new NullPointerException();
                }
                if (TreeTableModel.SelectType.SELECT != subItem.getSelectType()) continue;
                ++selectedSubItemCount;
            }
            if (0 == selectedSubItemCount) {
                parent.setSelectType(TreeTableModel.SelectType.UNSELECT);
            } else if (selectedSubItemCount > 0 && selectedSubItemCount < childSize) {
                parent.setSelectType(TreeTableModel.SelectType.HALF);
            } else {
                parent.setSelectType(TreeTableModel.SelectType.SELECT);
            }
        }
        this.addRowSelectionInterval(row, row);
        model.fireTableRowsUpdated(row, row);
        model.fireTableRowsUpdated(from, from);
    }

    public int getCheckBoxLeftIndent(TreeTableModel.RowItem item) {
        if (null == item) {
            return 18;
        }
        if (item.getParent() == null && !item.hasExpandAndCollapseIcon() && !this.checkBoxVisiable) {
            return 18;
        }
        if (item.hasExpandAndCollapseIcon()) {
            return item.getDepth() * 18;
        }
        return (item.getDepth() + 1) * 18;
    }

    private class ToggleMouseHandler
    extends MouseAdapter {
        private ToggleMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreeTable.this.updateTableRowStatus(event);
        }
    }
}

