/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox;

import com.huawei.ism.tool.base.context.StartParamContext;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.ui.LookAndFeelInstaller;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.executor.CmdExecutor;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.listener.HookHandler;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.singletoolbox.PreStartToolCheck;
import com.huawei.ism.tool.singletoolbox.utils.VerifyFilesService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class AppMain {
    private static final String DEFAULT_PLUGIN_CONFIG = "pluginsCfg.properties";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AppMain.class);
    private static ExecutorService executorTask;

    public static void main(String[] args) {
        StartParamContext.initStartEnv((String[])args);
        executorTask = Executors.newSingleThreadExecutor();
        String tmpDir = AppMain.getJavaIoTmpDir();
        boolean isSucc = FileUtils.createJavaIoTmpDir((String)tmpDir);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(tmpDir + "  createJavaIoTmpDir : " + isSucc);
        }
        ToolLoggerFactory.getLogger(AppMain.class).info("user.dir->" + System.getProperty("user.dir"));
        FrameworkInitiator.init();
        AppMain.setLanguage();
        LookAndFeelInstaller.installToolCustomUI();
        if (AppMain.initHookInstance()) {
            ApplicationContext.getInstance().getHookHandler().initialization();
        }
        if (ApplicationContext.getInstance().isWindowsOS()) {
            FileUtils.setLogsPermissions();
        }
        FrameworkInitiator.loadServiceFromCfg();
        AppMain.verifyPythonFiles();
        AppMain.checkRunEnv();
        if (ApplicationContext.getInstance().getHookHandler() != null) {
            ApplicationContext.getInstance().getHookHandler().seriveFinish();
        }
        FrameworkInitiator.loadPluginsFromCfg();
        AppMain.addShutDownHook();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("prepareDevCountResult: " + SceneDataExchange.getInstance().loadKV("prepareDevCountResult"));
        }
    }

    private static void verifyPythonFiles() {
        VerifyFilesService verifyFilesService = new VerifyFilesService();
        executorTask.execute(verifyFilesService);
    }

    private static String getJavaIoTmpDir() {
        String workDir;
        String tmpDir = workDir = SystemEnvUtil.getDefaultUserDir();
        File tmpFileDir = AppMain.findToolBoxDir(new File(workDir));
        if (tmpFileDir != null) {
            tmpDir = FilePathUtils.getCanonicalPath((File)tmpFileDir);
        }
        return FilePathUtils.getCanonicalPath((File)new File(tmpDir, "tmp"));
    }

    private static File findToolBoxDir(File path) {
        if (path == null) {
            return null;
        }
        File jreDir = new File(path, "jre");
        File toolsDir = new File(path, "tools");
        if (jreDir.exists() && toolsDir.exists()) {
            return path;
        }
        return AppMain.findToolBoxDir(path.getParentFile());
    }

    private static void addShutDownHook() {
        ShutDownHook shutDownHookTheard = new ShutDownHook();
        Thread shutDownHook = new Thread((Runnable)shutDownHookTheard, "Tool_shut_down_hook_Thread");
        shutDownHook.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught error", e);
            }
        });
        Runtime.getRuntime().addShutdownHook(shutDownHook);
    }

    private static void setLanguage() {
        String language = System.getenv("language");
        Locale lan = Locale.getDefault();
        Locale defaultlan = Locale.getDefault();
        ToolLoggerFactory.getLogger(AppMain.class).info("Input param for language: " + language);
        if (!StringUtils.isNULLStr((String)language)) {
            language = language.toLowerCase(Locale.ENGLISH).trim();
            lan = AppMain.getLan(language);
        } else {
            if (defaultlan != Locale.SIMPLIFIED_CHINESE) {
                defaultlan = Locale.ENGLISH;
            }
            lan = defaultlan;
            if (ApplicationContext.getInstance().isOEM()) {
                LanguageManager.LanguageCfg languageCfg = LanguageManager.getInstance().getCurLanguageCfg();
                switch (languageCfg) {
                    case ZH_CN: {
                        lan = Locale.SIMPLIFIED_CHINESE;
                        break;
                    }
                    case EN: {
                        lan = Locale.ENGLISH;
                        break;
                    }
                    default: {
                        lan = defaultlan;
                    }
                }
            }
        }
        LanguageManager.getInstance().setCurrentLanguage(lan);
    }

    public static Locale getLan(String language) {
        Locale lan = language.startsWith("zh") ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
        return lan;
    }

    private static void checkRunEnv() {
        try {
            String checkRes = PreStartToolCheck.checkRunEnv();
            if (checkRes != null) {
                if (null != ApplicationContext.getInstance().getHookHandler()) {
                    ApplicationContext.getInstance().getHookHandler().whenCheckNoPass(checkRes);
                }
                DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)checkRes);
                Runtime.getRuntime().halt(1);
            } else if (null != ApplicationContext.getInstance().getHookHandler()) {
                ApplicationContext.getInstance().getHookHandler().whenCheckPass();
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(AppMain.class).error("" + e);
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * Exception decompiling
     */
    private static String getStartHookClassName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean initHookInstance() {
        String hookClassName = null;
        hookClassName = AppMain.getStartHookClassName();
        if (hookClassName == null) {
            return false;
        }
        Class<?> hookClass = null;
        try {
            hookClass = Class.forName(hookClassName);
            Object hookClassObj = hookClass.newInstance();
            if (hookClassObj instanceof HookHandler) {
                ApplicationContext.getInstance().setHookHandler((HookHandler)hookClassObj);
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("" + e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("" + e);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
        return false;
    }

    private static class ShutDownHook
    implements Runnable {
        private ShutDownHook() {
        }

        @Override
        public void run() {
            this.deleteTempFile();
            this.removeNetUse();
        }

        private void deleteTempFile() {
            File file = new File(ApplicationContext.getInstance().getTmpPath());
            File[] subFiles = file.listFiles();
            if (subFiles != null && subFiles.length > 0) {
                for (File subfile : subFiles) {
                    String fileName = subfile.getName();
                    if (fileName.startsWith("grabCopyScript") && fileName.endsWith(".cmd") && LOGGER.isInfoEnabled()) {
                        LOGGER.info("delete file result:" + subfile.delete());
                    }
                    if (!fileName.startsWith("osName") || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("delete file result:" + subfile.delete());
                }
            }
        }

        private void removeNetUse() {
            List<String> paths = WmicConnectionManager.getNeedToReleasePath();
            for (String str : paths) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("remove net use path:" + CmdExecutor.executeCmd((String)str, (int)60));
            }
        }
    }
}

