/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox;

import com.huawei.ism.tool.base.ui.LookAndFeelInstaller;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.base.SingleProcessSupport;
import com.huawei.ism.tool.singletoolbox.AppMain;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.RightCtlUtils;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class PreStartToolCheck {
    private static final String ERROR_MSG = "errormsg";
    private static final String STORAGE_OEM_TOOL_NAME = "Oem Sub Tools";
    private static final String STORAGE_OEM_TOOL_LOCKNAME = "OemToolsLock";
    private static final String STORAGE_OEM_TOOL_ERRMSGKEY = "oem.app.context.lock.tools.fail";
    private static final String DEFAULT_CER = "defaultCer";
    private static final String WAITING_OPERATION = "waitingOperation";
    private static final String START_FAILED_MARKER = "startFailedMarker";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AppMain.class);
    private static final String RUN_MODE = "runMode";
    private static final String TEST_MODE = "test";
    private static final String AUTO_TEST = "autoTest";
    private static final String CONFIGURATION = "configuration";
    private static final String RELEASE_TIME_MARK = "20160602195024";
    private static final String CONFIG_FILE_NAME = "config.properties";
    private static final String USER_ACCOUNT = "userAccount";
    private static final String USER_ID_FUZZY_MATCH = "\"userId\":\".*\",\"lastTime";
    private static final String USER_ID_FUZZY_REPLACE = "\"userId\":\"******\",\"lastTime";
    private static final String USER_ID_REG = "\"userId\":\".*\"}";
    private static final String USER_ID_REG_REPLACE = "\"userId\":\"******\"}";
    private static String Check_Res = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remindUser(String msg) {
        String waitIngFile = ApplicationContext.getInstance().getWorkPath() + File.separator + WAITING_OPERATION;
        File wFile = FileUtils.getAndCreateFile((String)waitIngFile);
        FileLock lock = null;
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(wFile, "rw");
            lock = FileUtils.getFileLock((File)wFile, (RandomAccessFile)rf);
            PreStartToolCheck.notifyToolBoxFailed("{\"failedAction\":\"none\"}");
            Check_Res = ResourceUtil.getString((String)msg);
        }
        catch (Exception e) {
            try {
                LOGGER.error("get lock eror", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
                throw throwable;
            }
            PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
        }
        PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cfmAndNotifyToolBoxFailed(String msgKey, boolean cancelExit, Object ... params) {
        RandomAccessFile rf;
        FileLock lock;
        String waitIngFile;
        block6: {
            block7: {
                waitIngFile = ApplicationContext.getInstance().getWorkPath() + File.separator + WAITING_OPERATION;
                File wFile = FileUtils.getAndCreateFile((String)waitIngFile);
                lock = null;
                rf = null;
                rf = new RandomAccessFile(wFile, "rw");
                lock = FileUtils.getFileLock((File)wFile, (RandomAccessFile)rf);
                LookAndFeelInstaller.installToolCustomUI();
                WarningDialog dialog = DialogUtils.showYesNoDialogOnTop((String)ResourceUtil.getStringWithParams((String)msgKey, (Object[])params));
                if (0 == dialog.getValue()) {
                    PreStartToolCheck.notifyToolBoxFailed("{\"failedAction\":\"reActive\"}");
                    break block6;
                }
                if (cancelExit) break block7;
                PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
                return;
            }
            try {
                PreStartToolCheck.notifyToolBoxFailed("{\"failedAction\":\"none\"}");
            }
            catch (Exception e) {
                try {
                    LOGGER.error("get lock eror", (Throwable)e);
                }
                catch (Throwable throwable) {
                    PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
                    throw throwable;
                }
                PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
            }
        }
        PreStartToolCheck.releaseResource(waitIngFile, lock, rf);
    }

    private static void releaseResource(String waitIngFile, FileLock lock, RandomAccessFile rf) {
        StreamUtils.closeResource(null, (Closeable)rf);
        StreamUtils.closeResource(null, (Closeable)(lock == null ? null : lock.channel()));
        FileUtils.deleteAndReleaseLock((String)waitIngFile, (FileLock)lock);
    }

    private static void notifyToolBoxFailed(String msg) {
        try {
            String failedFilePath = ApplicationContext.getInstance().getWorkPath() + File.separator + START_FAILED_MARKER;
            File failedFile = new File(failedFilePath);
            if (!failedFile.exists() && LOGGER.isInfoEnabled()) {
                LOGGER.info(" create file result:" + failedFile.createNewFile());
            }
            if (msg != null) {
                Files.write(Paths.get(failedFilePath, new String[0]), msg.getBytes(Charset.forName("utf-8")), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("create failed file error!", (Throwable)e);
        }
    }

    private static String checkHaveRunRight() {
        try {
            Optional<String> msg;
            String userAccount = System.getenv(USER_ACCOUNT);
            ApplicationContext.getInstance().getToolLoginUser().setUserAccount(userAccount);
            if (!PreStartToolCheck.checkIniFile()) {
                LOGGER.error("ini have been modified");
                return "tool.run.right.ini.check.error";
            }
            if (!RightCtlUtils.isEServiceRun() && (msg = PreStartToolCheck.checkCompatible()).isPresent()) {
                return msg.get();
            }
            if (PreStartToolCheck.dontNeedCheckRightCond()) {
                LOGGER.info("don't have to check run right...");
                return null;
            }
            if (!PreStartToolCheck.isRunInToolBox()) {
                return "tool.run.right.invalid";
            }
            if (PreStartToolCheck.isOldToolBox()) {
                LOGGER.error("run tool in old toolbox.");
                return null;
            }
            String authFilePath = System.getenv("AuthFilePath");
            String timeRecFile = System.getenv("TimeRecordFilePath");
            if (authFilePath == null || timeRecFile == null) {
                LOGGER.warn("authFilePath:{} .timeRecFile:{}", (Object)StringUtils.getCleanMessage((String)authFilePath), (Object)StringUtils.getCleanMessage((String)timeRecFile));
                return "tool.run.right.invalid";
            }
            authFilePath = FilePathUtils.filterPath((String)authFilePath);
            timeRecFile = FilePathUtils.filterPath((String)timeRecFile);
            return PreStartToolCheck.checkIsRunOverTimeUse(authFilePath, timeRecFile);
        }
        catch (Error e) {
            LOGGER.error("check permission error!", (Throwable)e);
            return null;
        }
    }

    private static Optional<String> checkCompatible() {
        if (RightCtlUtils.isNewToolboxAndOldTool()) {
            LOGGER.error("tool needs to be upgraded");
            return Optional.of("tool.run.right.version.check.error");
        }
        if (RightCtlUtils.isOldToolboxAndNewTool()) {
            LOGGER.error("toolBox needs to be upgraded");
            return Optional.of("toolBox.run.right.version.check.error");
        }
        return Optional.empty();
    }

    private static boolean dontNeedCheckRightCond() {
        boolean isNonV3Svp = ApplicationContext.getInstance().isSpecificDeviceModeConfigured();
        boolean isTestMode = TEST_MODE.equals(System.getenv(RUN_MODE));
        boolean isOemMode = ApplicationContext.getInstance().isOEM();
        boolean isAutoProcessMode = AUTO_TEST.equals(System.getenv(RUN_MODE));
        return isNonV3Svp || isTestMode || isOemMode || isAutoProcessMode;
    }

    private static void checkIsBuildInCert(String authFilePath) {
        String parentPath;
        if (authFilePath != null && (parentPath = new File(authFilePath).getParent()).endsWith(DEFAULT_CER)) {
            ApplicationContext.getInstance().getToolLoginUser().setBuildInUser(true);
        }
    }

    private static boolean isRunInToolBox() {
        String tolBoxPath = ApplicationContext.getInstance().getWorkPath();
        return tolBoxPath.contains("tools");
    }

    private static boolean checkIniFile() {
        try {
            return SHAAndRSAVerifyUtils.getInstance().excuteVerify(new File(UserOpDataSaveUtil.getToolIniPath()));
        }
        catch (Exception e) {
            DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)ResourceUtil.getString((String)"tool.run.right.ini.check.error"));
            return false;
        }
    }

    private static String checkIsRunOverTimeUse(String authFilePath, String timeRecFile) {
        try {
            String desc = HttpsCertManager.getInstance().getClientCertDescInfo(authFilePath);
            if (StringUtils.isNULLStr((String)desc)) {
                return null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("cert desc:" + desc.replaceFirst(USER_ID_REG, USER_ID_REG_REPLACE));
            }
            PreStartToolCheck.checkIsBuildInCert(authFilePath);
            JSONObject authObj = new JSONObject(desc);
            JSONObject timeRecObj = RightCtlUtils.analysisDataFile((String)FilePathUtils.filterPath((String)timeRecFile));
            if (timeRecObj != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("timeRecObj:" + timeRecObj.toString().replaceFirst(USER_ID_FUZZY_MATCH, USER_ID_FUZZY_REPLACE));
                }
                RightCtlUtils.handleLoginUser((JSONObject)authObj, (JSONObject)timeRecObj);
            }
            ToolLoginUser loginUser = ApplicationContext.getInstance().getToolLoginUser();
            String toolRunRight = UserOpDataSaveUtil.getToolIniProp((String)"tool.support.roles");
            PreStartToolCheck.handleExpireRunCommonTool(loginUser, toolRunRight);
            if (loginUser.isInTrial() && RightCtlUtils.isCurToolSupportTrial()) {
                return null;
            }
            ToolUserRole role = loginUser.getUserRunRole();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("toolRunRight: roleCode:" + role.getCode() + " ss:" + ApplicationContext.getInstance().getWorkPath());
            }
            if (loginUser.isTrueGuest() && loginUser.isOverTime() && !RightCtlUtils.isRoleCanRun((String)toolRunRight, (int)role.getCode())) {
                PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.runright.trail.end.check.error", true, new Object[0]);
            }
            if (!RightCtlUtils.isAllCanRun((String)toolRunRight) && loginUser.isOverTime()) {
                PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.overtime.check.error", true, new Object[0]);
            }
            if (!RightCtlUtils.isRoleCanRun((String)toolRunRight, (int)role.getCode())) {
                return "tool.run.right.runright.check.error";
            }
        }
        catch (Exception e) {
            LOGGER.error("check time error", (Throwable)e);
        }
        return null;
    }

    private static void handleExpireRunCommonTool(ToolLoginUser loginUser, String toolRunRight) {
        if (!loginUser.isGuest() && RightCtlUtils.isAllCanRun((String)toolRunRight) && loginUser.isOverTime()) {
            loginUser.setUserRole(ToolUserRole.GUEST);
        }
        if (loginUser.isGoingOverTime()) {
            if (loginUser.isGuest()) {
                PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.trail.expire.warn.error", false, loginUser.getLeftDays());
            } else {
                PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.auth.expire.warn.error", false, loginUser.getLeftDays());
            }
        } else if (loginUser.getLeftDays() == 0.0 && !loginUser.isOverTime()) {
            if (loginUser.isGuest()) {
                if (loginUser.isInTrial()) {
                    PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.trail.expire.last.warn.error", false, new Object[0]);
                }
            } else {
                PreStartToolCheck.cfmAndNotifyToolBoxFailed("tool.run.right.auth.expire.last.warn.error", false, new Object[0]);
            }
        }
    }

    private static boolean isOldToolBox() {
        String date = PreStartToolCheck.getToolBoxReleaseDate("app.release.date");
        String appVer = PreStartToolCheck.getToolBoxReleaseDate("app.version");
        return appVer != null && (appVer.contains("Toolkit") || appVer.contains("ToolKit")) && date != null && !"".equals(date) && RELEASE_TIME_MARK.compareTo(date) > 0;
    }

    private static String getToolBoxReleaseDate(String key) {
        String tolBoxSysProp = UserOpDataSaveUtil.getToolBoxPath() + File.separator + CONFIGURATION + File.separator + "system.properties";
        String val = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), key);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{}:{}", (Object)key, (Object)StringUtils.getCleanMessage((String)val));
        }
        return val;
    }

    private static boolean checkSingleProcess() {
        if (!ApplicationContext.getInstance().isOEM()) {
            return true;
        }
        SingleProcessSupport singleProcessSupport = new SingleProcessSupport();
        TaskResult taskResult = singleProcessSupport.checkSingleProcess(STORAGE_OEM_TOOL_LOCKNAME);
        if (null != taskResult) {
            taskResult.setToolName(STORAGE_OEM_TOOL_NAME);
            taskResult.setErrorMsgKey(STORAGE_OEM_TOOL_ERRMSGKEY);
            String errorLocaleDescription = singleProcessSupport.getErrorLocaleDescription(taskResult);
            singleProcessSupport.release();
            Check_Res = errorLocaleDescription;
            return false;
        }
        return true;
    }

    public static String checkRunEnv() throws Exception {
        if (!PreStartToolCheck.checkSingleProcess()) {
            return Check_Res;
        }
        String path = ApplicationContext.getInstance().getWorkPath();
        if (StringUtils.isNULLStr((String)path)) {
            Check_Res = ResourceUtil.getString((String)"tool.userdir.isChinese");
            return Check_Res;
        }
        File checkFile = new File(ApplicationContext.getInstance().getPluginsCfgPath() + File.separator + CONFIG_FILE_NAME);
        String msg = PreStartToolCheck.checkHaveRunRight();
        if (null != msg) {
            PreStartToolCheck.remindUser(msg);
            return Check_Res;
        }
        path = path.replaceAll("\\\\", "");
        path = path.replaceAll("/", "");
        path = path.replaceAll(":", "");
        if (checkFile.exists()) {
            String reg = ResourceUtil.getValByProper((File)checkFile, (String)"app.regex");
            String boolStr = ResourceUtil.getValByProper((File)checkFile, (String)"app.Inversion");
            boolean ret = true;
            ret = "false".equals(boolStr) ? StringUtils.hasMatchStr((String)path, (String)reg) : !StringUtils.hasMatchStr((String)path, (String)reg);
            String lan = LanguageManager.getInstance().getCurrentLanguage().getLanguage();
            if (ret) {
                Check_Res = ResourceUtil.getValByProper((File)checkFile, (String)("app.desc." + lan));
            }
        }
        return Check_Res;
    }
}

