/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.singletoolbox.ui;

import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.singletoolbox.ui.ChooseLanguageDialogLayout;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import org.slf4j.Logger;

public class ChooseLanguageDialog
extends PublicDialog {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE = "Select Language";
    private static final String CONFIRM = "OK";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ChooseLanguageDialog.class);
    private ChooseLanguageDialogLayout layout = null;

    public ChooseLanguageDialog() {
        this.initUI();
        this.addListener();
    }

    private void initUI() {
        this.layout = new ChooseLanguageDialogLayout();
        this.layout.setCompName();
        this.getContentPanel().add(this.layout);
        this.setTitle(LANGUAGE);
        this.setSize(1000, 800);
        this.okBtn.setText(CONFIRM);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setResizable(true);
        this.setCancelButtonVisible(false);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage("language.png").getImage());
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    public void addListener() {
        ActionListener okBtnAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseLanguageDialog.this.addPerformed();
            }
        };
        this.okBtn.addActionListener(okBtnAction);
        WindowAdapter closeWindowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                this.closeWindow();
            }

            private void closeWindow() {
                ChooseLanguageDialog.this.dispose();
                Runtime.getRuntime().exit(0);
            }
        };
        this.addWindowListener(closeWindowAdapter);
    }

    private void addPerformed() {
        Locale language = Locale.SIMPLIFIED_CHINESE;
        if (this.layout.getJrbEnLanguage().isSelected()) {
            language = Locale.ENGLISH;
        }
        LanguageManager.getInstance().setCurrentLanguage(language);
        LOGGER.info(String.format(Locale.ROOT, "Language: %s", language.toString()));
        this.dispose();
    }
}

